/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.loader.defaultcolumn;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.segment.creator.ColumnIndexCreationInfo;
import org.apache.pinot.core.segment.creator.TextIndexType;
import org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.core.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.core.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.core.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnStatistics;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDefaultColumnHandler
implements DefaultColumnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDefaultColumnHandler.class);
    protected final File _indexDir;
    protected final Schema _schema;
    protected final SegmentMetadataImpl _segmentMetadata;
    protected final SegmentDirectory.Writer _segmentWriter;
    private final PropertiesConfiguration _segmentProperties;

    protected BaseDefaultColumnHandler(File indexDir, Schema schema, SegmentMetadataImpl segmentMetadata, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._schema = schema;
        this._segmentMetadata = segmentMetadata;
        this._segmentWriter = segmentWriter;
        this._segmentProperties = SegmentMetadataImpl.getPropertiesConfiguration(indexDir);
    }

    @Override
    public void updateDefaultColumns(IndexLoadingConfig indexLoadingConfig) throws Exception {
        Map<String, DefaultColumnAction> defaultColumnActionMap = this.computeDefaultColumnActionMap();
        if (defaultColumnActionMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, DefaultColumnAction> entry : defaultColumnActionMap.entrySet()) {
            this.updateDefaultColumn(entry.getKey(), entry.getValue(), indexLoadingConfig);
        }
        List<String> dimensionColumns = LoaderUtils.getStringListFromSegmentProperties("segment.dimension.column.names", this._segmentProperties);
        List<String> metricColumns = LoaderUtils.getStringListFromSegmentProperties("segment.metric.column.names", this._segmentProperties);
        List<String> dateTimeColumns = LoaderUtils.getStringListFromSegmentProperties("segment.datetime.column.names", this._segmentProperties);
        for (Map.Entry<String, DefaultColumnAction> entry : defaultColumnActionMap.entrySet()) {
            String column = entry.getKey();
            DefaultColumnAction action = entry.getValue();
            switch (action) {
                case ADD_DIMENSION: {
                    dimensionColumns.add(column);
                    break;
                }
                case ADD_METRIC: {
                    metricColumns.add(column);
                    break;
                }
                case ADD_DATE_TIME: {
                    dateTimeColumns.add(column);
                    break;
                }
                case REMOVE_DIMENSION: {
                    dimensionColumns.remove(column);
                    break;
                }
                case REMOVE_METRIC: {
                    metricColumns.remove(column);
                    break;
                }
                case REMOVE_DATE_TIME: {
                    dateTimeColumns.remove(column);
                }
            }
        }
        this._segmentProperties.setProperty("segment.dimension.column.names", dimensionColumns);
        this._segmentProperties.setProperty("segment.metric.column.names", metricColumns);
        this._segmentProperties.setProperty("segment.datetime.column.names", dateTimeColumns);
        File metadataFile = this._segmentProperties.getFile();
        File metadataBackUpFile = new File(metadataFile + ".bak");
        if (!metadataBackUpFile.exists()) {
            FileUtils.copyFile((File)metadataFile, (File)metadataBackUpFile);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this._segmentProperties.getFile());){
            this._segmentProperties.save((OutputStream)fileOutputStream);
        }
    }

    Map<String, DefaultColumnAction> computeDefaultColumnActionMap() {
        HashMap<String, DefaultColumnAction> defaultColumnActionMap = new HashMap<String, DefaultColumnAction>();
        Set columnsInSchema = this._schema.getPhysicalColumnNames();
        block5: for (String column : columnsInSchema) {
            FieldSpec fieldSpecInSchema = this._schema.getFieldSpecFor(column);
            Preconditions.checkNotNull((Object)fieldSpecInSchema);
            FieldSpec.FieldType fieldTypeInSchema = fieldSpecInSchema.getFieldType();
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata != null) {
                if (!columnMetadata.isAutoGenerated()) continue;
                FieldSpec.FieldType fieldTypeInMetadata = columnMetadata.getFieldType();
                if (fieldTypeInMetadata != fieldTypeInSchema) {
                    String failureMessage = "Field type: " + fieldTypeInMetadata + " for auto-generated column: " + column + " does not match field type: " + fieldTypeInSchema + " in schema, throw exception to drop and re-download the segment.";
                    throw new RuntimeException(failureMessage);
                }
                FieldSpec.DataType dataTypeInMetadata = columnMetadata.getDataType();
                FieldSpec.DataType dataTypeInSchema = fieldSpecInSchema.getDataType();
                boolean isSingleValueInMetadata = columnMetadata.isSingleValue();
                boolean isSingleValueInSchema = fieldSpecInSchema.isSingleValueField();
                String defaultValueInMetadata = columnMetadata.getDefaultNullValueString();
                String defaultValueInSchema = dataTypeInSchema == FieldSpec.DataType.BYTES ? BytesUtils.toHexString((byte[])((byte[])fieldSpecInSchema.getDefaultNullValue())) : fieldSpecInSchema.getDefaultNullValue().toString();
                if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_DATA_TYPE);
                        continue;
                    }
                    if (!defaultValueInSchema.equals(defaultValueInMetadata)) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_DEFAULT_VALUE);
                        continue;
                    }
                    if (isSingleValueInMetadata == isSingleValueInSchema) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_NUMBER_OF_VALUES);
                    continue;
                }
                if (fieldTypeInMetadata == FieldSpec.FieldType.METRIC) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_DATA_TYPE);
                        continue;
                    }
                    if (!defaultValueInSchema.equals(defaultValueInMetadata)) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_DEFAULT_VALUE);
                        continue;
                    }
                    if (isSingleValueInMetadata == isSingleValueInSchema) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_NUMBER_OF_VALUES);
                    continue;
                }
                if (fieldTypeInMetadata != FieldSpec.FieldType.DATE_TIME) continue;
                if (dataTypeInMetadata != dataTypeInSchema) {
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DATE_TIME_DATA_TYPE);
                    continue;
                }
                if (defaultValueInSchema.equals(defaultValueInMetadata)) continue;
                defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DATE_TIME_DEFAULT_VALUE);
                continue;
            }
            switch (fieldTypeInSchema) {
                case DIMENSION: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DIMENSION);
                    continue block5;
                }
                case METRIC: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_METRIC);
                    continue block5;
                }
                case DATE_TIME: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DATE_TIME);
                }
            }
            LOGGER.warn("Skip adding default column for column: {} with field type: {}", (Object)column, (Object)fieldTypeInSchema);
        }
        Set<String> columnsInMetadata = this._segmentMetadata.getAllColumns();
        for (String column : columnsInMetadata) {
            ColumnMetadata columnMetadata;
            if (columnsInSchema.contains(column) || !(columnMetadata = this._segmentMetadata.getColumnMetadataFor(column)).isAutoGenerated()) continue;
            FieldSpec.FieldType fieldTypeInMetadata = columnMetadata.getFieldType();
            if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DIMENSION);
                continue;
            }
            if (fieldTypeInMetadata == FieldSpec.FieldType.METRIC) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_METRIC);
                continue;
            }
            if (fieldTypeInMetadata != FieldSpec.FieldType.DATE_TIME) continue;
            defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DATE_TIME);
        }
        return defaultColumnActionMap;
    }

    protected abstract void updateDefaultColumn(String var1, DefaultColumnAction var2, IndexLoadingConfig var3) throws Exception;

    protected void removeColumnV1Indices(String column) throws IOException {
        FileUtils.forceDelete((File)new File(this._indexDir, column + ".dict"));
        File svFwdIndex = new File(this._indexDir, column + ".sv.sorted.fwd");
        if (svFwdIndex.exists()) {
            FileUtils.forceDelete((File)svFwdIndex);
        } else {
            FileUtils.forceDelete((File)new File(this._indexDir, column + ".mv.fwd"));
        }
        SegmentColumnarIndexCreator.removeColumnMetadataInfo(this._segmentProperties, column);
    }

    protected void createColumnV1Indices(String column) throws Exception {
        Object[] sortedArray;
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        Preconditions.checkNotNull((Object)fieldSpec);
        int totalDocs = this._segmentMetadata.getTotalDocs();
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        Object defaultValue = fieldSpec.getDefaultNullValue();
        boolean isSingleValue = fieldSpec.isSingleValueField();
        int maxNumberOfMultiValueElements = isSingleValue ? 0 : 1;
        int dictionaryElementSize = 0;
        switch (dataType) {
            case INT: {
                Preconditions.checkState((boolean)(defaultValue instanceof Integer));
                sortedArray = new int[]{(Integer)defaultValue};
                break;
            }
            case LONG: {
                Preconditions.checkState((boolean)(defaultValue instanceof Long));
                sortedArray = new long[]{(Long)defaultValue};
                break;
            }
            case FLOAT: {
                Preconditions.checkState((boolean)(defaultValue instanceof Float));
                sortedArray = new float[]{((Float)defaultValue).floatValue()};
                break;
            }
            case DOUBLE: {
                Preconditions.checkState((boolean)(defaultValue instanceof Double));
                sortedArray = new double[]{(Double)defaultValue};
                break;
            }
            case STRING: {
                Preconditions.checkState((boolean)(defaultValue instanceof String));
                String stringDefaultValue = (String)defaultValue;
                dictionaryElementSize = StringUtil.encodeUtf8((String)stringDefaultValue).length;
                sortedArray = new String[]{stringDefaultValue};
                break;
            }
            case BYTES: {
                Preconditions.checkState((boolean)(defaultValue instanceof byte[]));
                dictionaryElementSize = ((byte[])defaultValue).length;
                ByteArray bytesDefaultValue = new ByteArray((byte[])defaultValue);
                defaultValue = bytesDefaultValue;
                sortedArray = new ByteArray[]{bytesDefaultValue};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for column: " + column);
            }
        }
        DefaultColumnStatistics columnStatistics = new DefaultColumnStatistics(defaultValue, defaultValue, sortedArray, isSingleValue, totalDocs, maxNumberOfMultiValueElements);
        ColumnIndexCreationInfo columnIndexCreationInfo = new ColumnIndexCreationInfo(columnStatistics, true, false, true, defaultValue);
        try (SegmentDictionaryCreator creator = new SegmentDictionaryCreator(sortedArray, fieldSpec, this._indexDir, false);){
            creator.build();
        }
        if (isSingleValue) {
            var13_13 = null;
            try (SingleValueSortedForwardIndexCreator svFwdIndexCreator = new SingleValueSortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1);){
                for (int docId = 0; docId < totalDocs; ++docId) {
                    svFwdIndexCreator.putDictId(0);
                }
            }
            catch (Throwable docId) {
                var13_13 = docId;
                throw docId;
            }
        }
        var13_13 = null;
        try (MultiValueUnsortedForwardIndexCreator mvFwdIndexCreator = new MultiValueUnsortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1, totalDocs, totalDocs);){
            int[] dictIds = new int[]{0};
            for (int docId = 0; docId < totalDocs; ++docId) {
                mvFwdIndexCreator.putDictIdMV(dictIds);
            }
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, columnIndexCreationInfo, totalDocs, fieldSpec, true, dictionaryElementSize, true, TextIndexType.NONE);
    }

    protected static enum DefaultColumnAction {
        ADD_DIMENSION,
        ADD_METRIC,
        ADD_DATE_TIME,
        REMOVE_DIMENSION,
        REMOVE_METRIC,
        REMOVE_DATE_TIME,
        UPDATE_DIMENSION_DATA_TYPE,
        UPDATE_DIMENSION_DEFAULT_VALUE,
        UPDATE_DIMENSION_NUMBER_OF_VALUES,
        UPDATE_METRIC_DATA_TYPE,
        UPDATE_METRIC_DEFAULT_VALUE,
        UPDATE_METRIC_NUMBER_OF_VALUES,
        UPDATE_DATE_TIME_DATA_TYPE,
        UPDATE_DATE_TIME_DEFAULT_VALUE;


        boolean isAddAction() {
            return this == ADD_DIMENSION || this == ADD_METRIC || this == ADD_DATE_TIME;
        }

        boolean isUpdateAction() {
            return !this.isAddAction() && !this.isRemoveAction();
        }

        boolean isRemoveAction() {
            return this == REMOVE_DIMENSION || this == REMOVE_METRIC || this == REMOVE_DATE_TIME;
        }
    }
}

