/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.loader.columnminmaxvalue;

import com.google.common.base.Preconditions;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.core.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.index.readers.BytesDictionary;
import org.apache.pinot.core.segment.index.readers.DoubleDictionary;
import org.apache.pinot.core.segment.index.readers.FloatDictionary;
import org.apache.pinot.core.segment.index.readers.IntDictionary;
import org.apache.pinot.core.segment.index.readers.LongDictionary;
import org.apache.pinot.core.segment.index.readers.StringDictionary;
import org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.spi.data.Schema;

public class ColumnMinMaxValueGenerator {
    private final SegmentMetadataImpl _segmentMetadata;
    private final PropertiesConfiguration _segmentProperties;
    private final SegmentDirectory.Writer _segmentWriter;
    private final ColumnMinMaxValueGeneratorMode _columnMinMaxValueGeneratorMode;
    private boolean _minMaxValueAdded;

    public ColumnMinMaxValueGenerator(SegmentMetadataImpl segmentMetadata, SegmentDirectory.Writer segmentWriter, ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode) {
        this._segmentMetadata = segmentMetadata;
        this._segmentProperties = SegmentMetadataImpl.getPropertiesConfiguration(this._segmentMetadata.getIndexDir());
        this._segmentWriter = segmentWriter;
        this._columnMinMaxValueGeneratorMode = columnMinMaxValueGeneratorMode;
    }

    public void addColumnMinMaxValue() throws Exception {
        Preconditions.checkState((this._columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE ? 1 : 0) != 0);
        Schema schema = this._segmentMetadata.getSchema();
        HashSet columnsToAddMinMaxValue = new HashSet(schema.getPhysicalColumnNames());
        switch (this._columnMinMaxValueGeneratorMode) {
            case TIME: {
                columnsToAddMinMaxValue.removeAll(schema.getDimensionNames());
            }
            case NON_METRIC: {
                columnsToAddMinMaxValue.removeAll(schema.getMetricNames());
            }
        }
        for (String column : columnsToAddMinMaxValue) {
            this.addColumnMinMaxValueForColumn(column);
        }
        this.saveMetadata();
    }

    /*
     * Unable to fully structure code
     */
    private void addColumnMinMaxValueForColumn(String columnName) throws Exception {
        columnMetadata = this._segmentMetadata.getColumnMetadataFor(columnName);
        if (!columnMetadata.hasDictionary() || columnMetadata.getMinValue() != null || columnMetadata.getMaxValue() != null) {
            return;
        }
        dictionaryBuffer = this._segmentWriter.getIndexFor(columnName, ColumnIndexType.DICTIONARY);
        dataType = columnMetadata.getDataType();
        length = columnMetadata.getCardinality();
        switch (1.$SwitchMap$org$apache$pinot$spi$data$FieldSpec$DataType[dataType.ordinal()]) {
            case 1: {
                intDictionary = new IntDictionary(dictionaryBuffer, length);
                var7_12 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, intDictionary.getStringValue(0), intDictionary.getStringValue(length - 1));
                if (intDictionary == null) break;
                if (var7_12 == null) ** GOTO lbl21
                try {
                    intDictionary.close();
                }
                catch (Throwable var8_18) {
                    var7_12.addSuppressed(var8_18);
                }
                break;
lbl21:
                // 1 sources

                intDictionary.close();
                break;
                catch (Throwable var8_19) {
                    try {
                        var7_12 = var8_19;
                        throw var8_19;
                    }
                    catch (Throwable var9_30) {
                        if (intDictionary != null) {
                            if (var7_12 != null) {
                                try {
                                    intDictionary.close();
                                }
                                catch (Throwable var10_31) {
                                    var7_12.addSuppressed(var10_31);
                                }
                            } else {
                                intDictionary.close();
                            }
                        }
                        throw var9_30;
                    }
                }
            }
            case 2: {
                longDictionary = new LongDictionary(dictionaryBuffer, length);
                var7_13 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, longDictionary.getStringValue(0), longDictionary.getStringValue(length - 1));
                if (longDictionary == null) break;
                if (var7_13 == null) ** GOTO lbl51
                try {
                    longDictionary.close();
                }
                catch (Throwable var8_20) {
                    var7_13.addSuppressed(var8_20);
                }
                break;
lbl51:
                // 1 sources

                longDictionary.close();
                break;
                catch (Throwable var8_21) {
                    try {
                        var7_13 = var8_21;
                        throw var8_21;
                    }
                    catch (Throwable var11_32) {
                        if (longDictionary != null) {
                            if (var7_13 != null) {
                                try {
                                    longDictionary.close();
                                }
                                catch (Throwable var12_33) {
                                    var7_13.addSuppressed(var12_33);
                                }
                            } else {
                                longDictionary.close();
                            }
                        }
                        throw var11_32;
                    }
                }
            }
            case 3: {
                floatDictionary = new FloatDictionary(dictionaryBuffer, length);
                var7_14 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, floatDictionary.getStringValue(0), floatDictionary.getStringValue(length - 1));
                if (floatDictionary == null) break;
                if (var7_14 == null) ** GOTO lbl81
                try {
                    floatDictionary.close();
                }
                catch (Throwable var8_22) {
                    var7_14.addSuppressed(var8_22);
                }
                break;
lbl81:
                // 1 sources

                floatDictionary.close();
                break;
                catch (Throwable var8_23) {
                    try {
                        var7_14 = var8_23;
                        throw var8_23;
                    }
                    catch (Throwable var13_34) {
                        if (floatDictionary != null) {
                            if (var7_14 != null) {
                                try {
                                    floatDictionary.close();
                                }
                                catch (Throwable var14_35) {
                                    var7_14.addSuppressed(var14_35);
                                }
                            } else {
                                floatDictionary.close();
                            }
                        }
                        throw var13_34;
                    }
                }
            }
            case 4: {
                doubleDictionary = new DoubleDictionary(dictionaryBuffer, length);
                var7_15 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, doubleDictionary.getStringValue(0), doubleDictionary.getStringValue(length - 1));
                if (doubleDictionary == null) break;
                if (var7_15 == null) ** GOTO lbl111
                try {
                    doubleDictionary.close();
                }
                catch (Throwable var8_24) {
                    var7_15.addSuppressed(var8_24);
                }
                break;
lbl111:
                // 1 sources

                doubleDictionary.close();
                break;
                catch (Throwable var8_25) {
                    try {
                        var7_15 = var8_25;
                        throw var8_25;
                    }
                    catch (Throwable var15_36) {
                        if (doubleDictionary != null) {
                            if (var7_15 != null) {
                                try {
                                    doubleDictionary.close();
                                }
                                catch (Throwable var16_37) {
                                    var7_15.addSuppressed(var16_37);
                                }
                            } else {
                                doubleDictionary.close();
                            }
                        }
                        throw var15_36;
                    }
                }
            }
            case 5: {
                stringDictionary = new StringDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength(), (byte)columnMetadata.getPaddingCharacter());
                var7_16 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, stringDictionary.getStringValue(0), stringDictionary.getStringValue(length - 1));
                if (stringDictionary == null) break;
                if (var7_16 == null) ** GOTO lbl141
                try {
                    stringDictionary.close();
                }
                catch (Throwable var8_26) {
                    var7_16.addSuppressed(var8_26);
                }
                break;
lbl141:
                // 1 sources

                stringDictionary.close();
                break;
                catch (Throwable var8_27) {
                    try {
                        var7_16 = var8_27;
                        throw var8_27;
                    }
                    catch (Throwable var17_38) {
                        if (stringDictionary != null) {
                            if (var7_16 != null) {
                                try {
                                    stringDictionary.close();
                                }
                                catch (Throwable var18_39) {
                                    var7_16.addSuppressed(var18_39);
                                }
                            } else {
                                stringDictionary.close();
                            }
                        }
                        throw var17_38;
                    }
                }
            }
            case 6: {
                bytesDictionary = new BytesDictionary(dictionaryBuffer, length, columnMetadata.getColumnMaxLength());
                var7_17 = null;
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(this._segmentProperties, columnName, bytesDictionary.getStringValue(0), bytesDictionary.getStringValue(length - 1));
                if (bytesDictionary == null) break;
                if (var7_17 == null) ** GOTO lbl171
                try {
                    bytesDictionary.close();
                }
                catch (Throwable var8_28) {
                    var7_17.addSuppressed(var8_28);
                }
                break;
lbl171:
                // 1 sources

                bytesDictionary.close();
                break;
                catch (Throwable var8_29) {
                    try {
                        var7_17 = var8_29;
                        throw var8_29;
                    }
                    catch (Throwable var19_40) {
                        if (bytesDictionary != null) {
                            if (var7_17 != null) {
                                try {
                                    bytesDictionary.close();
                                }
                                catch (Throwable var20_41) {
                                    var7_17.addSuppressed(var20_41);
                                }
                            } else {
                                bytesDictionary.close();
                            }
                        }
                        throw var19_40;
                    }
                }
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnName);
            }
        }
        this._minMaxValueAdded = true;
    }

    private void saveMetadata() throws Exception {
        if (this._minMaxValueAdded) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this._segmentProperties.getFile());){
                this._segmentProperties.save((OutputStream)fileOutputStream);
            }
        }
    }
}

