/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.loader;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.index.loader.bloomfilter.BloomFilterHandler;
import org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGenerator;
import org.apache.pinot.core.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.core.segment.index.loader.defaultcolumn.DefaultColumnHandlerFactory;
import org.apache.pinot.core.segment.index.loader.invertedindex.InvertedIndexHandler;
import org.apache.pinot.core.segment.index.loader.invertedindex.RangeIndexHandler;
import org.apache.pinot.core.segment.index.loader.invertedindex.TextIndexHandler;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.core.startree.StarTreeBuilderUtils;
import org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.core.startree.v2.builder.MultipleTreesBuilder;
import org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreProcessor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreProcessor.class);
    private final File _indexDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final SegmentDirectory _segmentDirectory;
    private SegmentMetadataImpl _segmentMetadata;

    public SegmentPreProcessor(File indexDir, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        this._indexDir = indexDir;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._segmentMetadata = new SegmentMetadataImpl(indexDir);
        this._segmentDirectory = SegmentDirectory.createFromLocalFS(indexDir, this._segmentMetadata, ReadMode.mmap);
    }

    public void process() throws Exception {
        if (this._segmentMetadata.getTotalDocs() == 0) {
            return;
        }
        File[] directoryListing = this._indexDir.listFiles();
        String tempFileExtension = ".bitmap.inv.tmp";
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (!child.getName().endsWith(tempFileExtension)) continue;
                FileUtils.deleteQuietly((File)child);
            }
        }
        try (SegmentDirectory.Writer segmentWriter = this._segmentDirectory.createWriter();){
            ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode;
            if (this._schema != null) {
                DefaultColumnHandler defaultColumnHandler = DefaultColumnHandlerFactory.getDefaultColumnHandler(this._indexDir, this._schema, this._segmentMetadata, segmentWriter);
                defaultColumnHandler.updateDefaultColumns(this._indexLoadingConfig);
                this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
                this._segmentDirectory.reloadMetadata();
            }
            InvertedIndexHandler invertedIndexHandler = new InvertedIndexHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            invertedIndexHandler.createInvertedIndices();
            RangeIndexHandler rangeIndexHandler = new RangeIndexHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            rangeIndexHandler.createRangeIndices();
            Set<String> textIndexColumns = this._indexLoadingConfig.getTextIndexColumns();
            if (textIndexColumns.size() > 0) {
                TextIndexHandler textIndexHandler = new TextIndexHandler(this._indexDir, this._segmentMetadata, textIndexColumns, segmentWriter);
                textIndexHandler.createTextIndexesOnSegmentLoad();
            }
            BloomFilterHandler bloomFilterHandler = new BloomFilterHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            bloomFilterHandler.createBloomFilters();
            if (this._indexLoadingConfig.isEnableDynamicStarTreeCreation()) {
                List<StarTreeV2BuilderConfig> starTreeBuilderConfigs = StarTreeBuilderUtils.generateBuilderConfigs(this._indexLoadingConfig.getStarTreeIndexConfigs(), this._indexLoadingConfig.isEnableDefaultStarTree(), this._segmentMetadata);
                boolean shouldGenerateStarTree = !starTreeBuilderConfigs.isEmpty();
                List<StarTreeV2Metadata> starTreeMetadataList = this._segmentMetadata.getStarTreeV2MetadataList();
                if (starTreeMetadataList != null) {
                    if (StarTreeUtils.shouldRemoveExistingStarTrees(starTreeBuilderConfigs, starTreeMetadataList)) {
                        LOGGER.info("Removing star-trees from segment: {}", (Object)this._segmentMetadata.getName());
                        StarTreeUtils.removeStarTrees(this._indexDir);
                        this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
                    } else {
                        shouldGenerateStarTree = false;
                    }
                }
                if (shouldGenerateStarTree) {
                    try (MultipleTreesBuilder builder = new MultipleTreesBuilder(starTreeBuilderConfigs, this._indexDir, MultipleTreesBuilder.BuildMode.OFF_HEAP);){
                        builder.build();
                    }
                    this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
                }
            }
            if ((columnMinMaxValueGeneratorMode = this._indexLoadingConfig.getColumnMinMaxValueGeneratorMode()) != ColumnMinMaxValueGeneratorMode.NONE) {
                ColumnMinMaxValueGenerator columnMinMaxValueGenerator = new ColumnMinMaxValueGenerator(this._segmentMetadata, segmentWriter, columnMinMaxValueGeneratorMode);
                columnMinMaxValueGenerator.addColumnMinMaxValue();
            }
            segmentWriter.save();
        }
    }

    @Override
    public void close() throws Exception {
        this._segmentDirectory.close();
    }
}

