/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.datasource;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.segment.index.datasource.BaseDataSource;
import org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.NullValueVectorReader;
import org.apache.pinot.core.segment.index.readers.TextIndexReader;
import org.apache.pinot.spi.data.FieldSpec;

public class MutableDataSource
extends BaseDataSource {
    public MutableDataSource(FieldSpec fieldSpec, int numDocs, int numValues, int maxNumValuesPerMVEntry, @Nullable PartitionFunction partitionFunction, @Nullable Set<Integer> partitions, @Nullable Comparable minValue, @Nullable Comparable maxValue, ForwardIndexReader forwardIndex, @Nullable Dictionary dictionary, @Nullable InvertedIndexReader invertedIndex, @Nullable InvertedIndexReader rangeIndex, @Nullable TextIndexReader textIndex, @Nullable BloomFilterReader bloomFilter, @Nullable NullValueVectorReader nullValueVector) {
        super(new MutableDataSourceMetadata(fieldSpec, numDocs, numValues, maxNumValuesPerMVEntry, partitionFunction, partitions, minValue, maxValue), forwardIndex, dictionary, invertedIndex, rangeIndex, textIndex, bloomFilter, nullValueVector);
    }

    private static class MutableDataSourceMetadata
    implements DataSourceMetadata {
        final FieldSpec _fieldSpec;
        final int _numDocs;
        final int _numValues;
        final int _maxNumValuesPerMVEntry;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;
        final Comparable _minValue;
        final Comparable _maxValue;

        MutableDataSourceMetadata(FieldSpec fieldSpec, int numDocs, int numValues, int maxNumValuesPerMVEntry, @Nullable PartitionFunction partitionFunction, @Nullable Set<Integer> partitions, @Nullable Comparable minValue, @Nullable Comparable maxValue) {
            this._fieldSpec = fieldSpec;
            this._numDocs = numDocs;
            this._numValues = numValues;
            this._maxNumValuesPerMVEntry = maxNumValuesPerMVEntry;
            if (partitionFunction != null) {
                this._partitionFunction = partitionFunction;
                this._partitions = partitions;
            } else {
                this._partitionFunction = null;
                this._partitions = null;
            }
            this._minValue = minValue;
            this._maxValue = maxValue;
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        @Override
        public boolean isSorted() {
            return false;
        }

        @Override
        public int getNumDocs() {
            return this._numDocs;
        }

        @Override
        public int getNumValues() {
            return this._numValues;
        }

        @Override
        public int getMaxNumValuesPerMVEntry() {
            return this._maxNumValuesPerMVEntry;
        }

        @Override
        @Nullable
        public Comparable getMinValue() {
            return this._minValue;
        }

        @Override
        @Nullable
        public Comparable getMaxValue() {
            return this._maxValue;
        }

        @Override
        @Nullable
        public PartitionFunction getPartitionFunction() {
            return this._partitionFunction;
        }

        @Override
        @Nullable
        public Set<Integer> getPartitions() {
            return this._partitions;
        }
    }
}

