/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.datasource;

import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.core.segment.index.datasource.BaseDataSource;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.spi.data.FieldSpec;

public class ImmutableDataSource
extends BaseDataSource {
    public ImmutableDataSource(ColumnMetadata columnMetadata, ColumnIndexContainer columnIndexContainer) {
        super(new ImmutableDataSourceMetadata(columnMetadata), columnIndexContainer.getForwardIndex(), columnIndexContainer.getDictionary(), columnIndexContainer.getInvertedIndex(), columnIndexContainer.getRangeIndex(), columnIndexContainer.getTextIndex(), columnIndexContainer.getBloomFilter(), columnIndexContainer.getNullValueVector());
    }

    private static class ImmutableDataSourceMetadata
    implements DataSourceMetadata {
        final FieldSpec _fieldSpec;
        final boolean _sorted;
        final int _numDocs;
        final int _numValues;
        final int _maxNumValuesPerMVEntry;
        final Comparable _minValue;
        final Comparable _maxValue;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;

        ImmutableDataSourceMetadata(ColumnMetadata columnMetadata) {
            this._fieldSpec = columnMetadata.getFieldSpec();
            this._sorted = columnMetadata.isSorted();
            this._numDocs = columnMetadata.getTotalDocs();
            this._numValues = columnMetadata.getTotalNumberOfEntries();
            this._maxNumValuesPerMVEntry = this._fieldSpec.isSingleValueField() ? -1 : columnMetadata.getMaxNumberOfMultiValues();
            this._minValue = columnMetadata.getMinValue();
            this._maxValue = columnMetadata.getMaxValue();
            this._partitionFunction = columnMetadata.getPartitionFunction();
            this._partitions = columnMetadata.getPartitions();
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        @Override
        public boolean isSorted() {
            return this._sorted;
        }

        @Override
        public int getNumDocs() {
            return this._numDocs;
        }

        @Override
        public int getNumValues() {
            return this._numValues;
        }

        @Override
        public int getMaxNumValuesPerMVEntry() {
            return this._maxNumValuesPerMVEntry;
        }

        @Override
        @Nullable
        public Comparable getMinValue() {
            return this._minValue;
        }

        @Override
        @Nullable
        public Comparable getMaxValue() {
            return this._maxValue;
        }

        @Override
        @Nullable
        public PartitionFunction getPartitionFunction() {
            return this._partitionFunction;
        }

        @Override
        @Nullable
        public Set<Integer> getPartitions() {
            return this._partitions;
        }
    }
}

