/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.datasource;

import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.NullValueVectorReader;
import org.apache.pinot.core.segment.index.readers.TextIndexReader;

public abstract class BaseDataSource
implements DataSource {
    private final DataSourceMetadata _dataSourceMetadata;
    private final ForwardIndexReader<?> _forwardIndex;
    private final Dictionary _dictionary;
    private final InvertedIndexReader<?> _invertedIndex;
    private final InvertedIndexReader<?> _rangeIndex;
    private final TextIndexReader _textIndex;
    private final BloomFilterReader _bloomFilter;
    private final NullValueVectorReader _nullValueVector;

    public BaseDataSource(DataSourceMetadata dataSourceMetadata, ForwardIndexReader<?> forwardIndex, @Nullable Dictionary dictionary, @Nullable InvertedIndexReader<?> invertedIndex, @Nullable InvertedIndexReader<?> rangeIndex, @Nullable TextIndexReader textIndex, @Nullable BloomFilterReader bloomFilter, @Nullable NullValueVectorReader nullValueVector) {
        this._dataSourceMetadata = dataSourceMetadata;
        this._forwardIndex = forwardIndex;
        this._dictionary = dictionary;
        this._invertedIndex = invertedIndex;
        this._rangeIndex = rangeIndex;
        this._textIndex = textIndex;
        this._bloomFilter = bloomFilter;
        this._nullValueVector = nullValueVector;
    }

    @Override
    public DataSourceMetadata getDataSourceMetadata() {
        return this._dataSourceMetadata;
    }

    @Override
    public ForwardIndexReader<?> getForwardIndex() {
        return this._forwardIndex;
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    @Nullable
    public InvertedIndexReader<?> getInvertedIndex() {
        return this._invertedIndex;
    }

    @Override
    @Nullable
    public InvertedIndexReader<?> getRangeIndex() {
        return this._rangeIndex;
    }

    @Override
    @Nullable
    public TextIndexReader getTextIndex() {
        return this._textIndex;
    }

    @Override
    @Nullable
    public BloomFilterReader getBloomFilter() {
        return this._bloomFilter;
    }

    @Override
    @Nullable
    public NullValueVectorReader getNullValueVector() {
        return this._nullValueVector;
    }
}

