/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.column;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.core.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.core.segment.index.readers.BytesDictionary;
import org.apache.pinot.core.segment.index.readers.DoubleDictionary;
import org.apache.pinot.core.segment.index.readers.FloatDictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.IntDictionary;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.LongDictionary;
import org.apache.pinot.core.segment.index.readers.NullValueVectorReaderImpl;
import org.apache.pinot.core.segment.index.readers.OnHeapDoubleDictionary;
import org.apache.pinot.core.segment.index.readers.OnHeapFloatDictionary;
import org.apache.pinot.core.segment.index.readers.OnHeapIntDictionary;
import org.apache.pinot.core.segment.index.readers.OnHeapLongDictionary;
import org.apache.pinot.core.segment.index.readers.OnHeapStringDictionary;
import org.apache.pinot.core.segment.index.readers.RangeIndexReader;
import org.apache.pinot.core.segment.index.readers.StringDictionary;
import org.apache.pinot.core.segment.index.readers.TextIndexReader;
import org.apache.pinot.core.segment.index.readers.bloom.BloomFilterReaderFactory;
import org.apache.pinot.core.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.FixedBitSVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.sorted.SortedIndexReaderImpl;
import org.apache.pinot.core.segment.index.readers.text.LuceneTextIndexReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhysicalColumnIndexContainer
implements ColumnIndexContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalColumnIndexContainer.class);
    private final ForwardIndexReader<?> _forwardIndex;
    private final InvertedIndexReader<?> _invertedIndex;
    private final InvertedIndexReader<?> _rangeIndex;
    private final TextIndexReader _textIndex;
    private final BaseImmutableDictionary _dictionary;
    private final BloomFilterReader _bloomFilter;
    private final NullValueVectorReaderImpl _nullValueVectorReader;

    public PhysicalColumnIndexContainer(SegmentDirectory.Reader segmentReader, ColumnMetadata metadata, IndexLoadingConfig indexLoadingConfig, File segmentIndexDir) throws IOException {
        String columnName = metadata.getColumnName();
        boolean loadInvertedIndex = indexLoadingConfig.getInvertedIndexColumns().contains(columnName);
        boolean loadRangeIndex = indexLoadingConfig.getRangeIndexColumns().contains(columnName);
        boolean loadTextIndex = indexLoadingConfig.getTextIndexColumns().contains(columnName);
        boolean loadOnHeapDictionary = indexLoadingConfig.getOnHeapDictionaryColumns().contains(columnName);
        BloomFilterConfig bloomFilterConfig = indexLoadingConfig.getBloomFilterConfigs().get(columnName);
        if (segmentReader.hasIndexFor(columnName, ColumnIndexType.NULLVALUE_VECTOR)) {
            PinotDataBuffer nullValueVectorBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.NULLVALUE_VECTOR);
            this._nullValueVectorReader = new NullValueVectorReaderImpl(nullValueVectorBuffer);
        } else {
            this._nullValueVectorReader = null;
        }
        if (loadTextIndex) {
            Preconditions.checkState((boolean)segmentReader.hasIndexFor(columnName, ColumnIndexType.TEXT_INDEX));
            Map<String, Map<String, String>> columnProperties = indexLoadingConfig.getColumnProperties();
            this._textIndex = new LuceneTextIndexReader(columnName, segmentIndexDir, metadata.getTotalDocs(), columnProperties.get(columnName));
        } else {
            this._textIndex = null;
        }
        PinotDataBuffer fwdIndexBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.FORWARD_INDEX);
        if (metadata.hasDictionary()) {
            if (bloomFilterConfig != null) {
                PinotDataBuffer bloomFilterBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.BLOOM_FILTER);
                this._bloomFilter = BloomFilterReaderFactory.getBloomFilterReader(bloomFilterBuffer, bloomFilterConfig.isLoadOnHeap());
            } else {
                this._bloomFilter = null;
            }
            this._dictionary = PhysicalColumnIndexContainer.loadDictionary(segmentReader.getIndexFor(columnName, ColumnIndexType.DICTIONARY), metadata, loadOnHeapDictionary);
            if (metadata.isSingleValue()) {
                if (metadata.isSorted()) {
                    SortedIndexReaderImpl sortedIndexReader;
                    this._forwardIndex = sortedIndexReader = new SortedIndexReaderImpl(fwdIndexBuffer, metadata.getCardinality());
                    this._invertedIndex = sortedIndexReader;
                    this._rangeIndex = null;
                    return;
                }
                this._forwardIndex = new FixedBitSVForwardIndexReader(fwdIndexBuffer, metadata.getTotalDocs(), metadata.getBitsPerElement());
            } else {
                this._forwardIndex = new FixedBitMVForwardIndexReader(fwdIndexBuffer, metadata.getTotalDocs(), metadata.getTotalNumberOfEntries(), metadata.getBitsPerElement());
            }
            this._invertedIndex = loadInvertedIndex ? new BitmapInvertedIndexReader(segmentReader.getIndexFor(columnName, ColumnIndexType.INVERTED_INDEX), metadata.getCardinality()) : null;
            this._rangeIndex = loadRangeIndex ? new RangeIndexReader(segmentReader.getIndexFor(columnName, ColumnIndexType.RANGE_INDEX)) : null;
        } else {
            this._forwardIndex = PhysicalColumnIndexContainer.loadRawForwardIndex(fwdIndexBuffer, metadata.getDataType());
            this._dictionary = null;
            this._bloomFilter = null;
            this._rangeIndex = null;
            this._invertedIndex = null;
        }
    }

    @Override
    public ForwardIndexReader<?> getForwardIndex() {
        return this._forwardIndex;
    }

    @Override
    public InvertedIndexReader<?> getInvertedIndex() {
        return this._invertedIndex;
    }

    @Override
    public InvertedIndexReader<?> getRangeIndex() {
        return this._rangeIndex;
    }

    @Override
    public TextIndexReader getTextIndex() {
        return this._textIndex;
    }

    @Override
    public BaseImmutableDictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    public BloomFilterReader getBloomFilter() {
        return this._bloomFilter;
    }

    @Override
    public NullValueVectorReaderImpl getNullValueVector() {
        return this._nullValueVectorReader;
    }

    public static BaseImmutableDictionary loadDictionary(PinotDataBuffer dictionaryBuffer, ColumnMetadata metadata, boolean loadOnHeap) {
        FieldSpec.DataType dataType = metadata.getDataType();
        if (loadOnHeap) {
            String columnName = metadata.getColumnName();
            LOGGER.info("Loading on-heap dictionary for column: {}", (Object)columnName);
        }
        int length = metadata.getCardinality();
        switch (dataType) {
            case INT: {
                return loadOnHeap ? new OnHeapIntDictionary(dictionaryBuffer, length) : new IntDictionary(dictionaryBuffer, length);
            }
            case LONG: {
                return loadOnHeap ? new OnHeapLongDictionary(dictionaryBuffer, length) : new LongDictionary(dictionaryBuffer, length);
            }
            case FLOAT: {
                return loadOnHeap ? new OnHeapFloatDictionary(dictionaryBuffer, length) : new FloatDictionary(dictionaryBuffer, length);
            }
            case DOUBLE: {
                return loadOnHeap ? new OnHeapDoubleDictionary(dictionaryBuffer, length) : new DoubleDictionary(dictionaryBuffer, length);
            }
            case STRING: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                byte paddingByte = (byte)metadata.getPaddingCharacter();
                return loadOnHeap ? new OnHeapStringDictionary(dictionaryBuffer, length, numBytesPerValue, paddingByte) : new StringDictionary(dictionaryBuffer, length, numBytesPerValue, paddingByte);
            }
            case BYTES: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                return new BytesDictionary(dictionaryBuffer, length, numBytesPerValue);
            }
        }
        throw new IllegalStateException("Illegal data type for dictionary: " + dataType);
    }

    private static ForwardIndexReader<?> loadRawForwardIndex(PinotDataBuffer forwardIndexBuffer, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new FixedByteChunkSVForwardIndexReader(forwardIndexBuffer, dataType);
            }
            case STRING: 
            case BYTES: {
                return new VarByteChunkSVForwardIndexReader(forwardIndexBuffer, dataType);
            }
        }
        throw new IllegalStateException("Illegal data type for raw forward index: " + dataType);
    }

    @Override
    public void close() throws IOException {
        this._forwardIndex.close();
        if (this._invertedIndex != null) {
            this._invertedIndex.close();
        }
        if (this._rangeIndex != null) {
            this._rangeIndex.close();
        }
        if (this._dictionary != null) {
            this._dictionary.close();
        }
        if (this._textIndex != null) {
            this._textIndex.close();
        }
        if (this._bloomFilter != null) {
            this._bloomFilter.close();
        }
    }
}

