/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.column;

import org.apache.pinot.core.segment.index.column.BaseVirtualColumnProvider;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.readers.ConstantValueBytesDictionary;
import org.apache.pinot.core.segment.index.readers.ConstantValueDoubleDictionary;
import org.apache.pinot.core.segment.index.readers.ConstantValueFloatDictionary;
import org.apache.pinot.core.segment.index.readers.ConstantValueIntDictionary;
import org.apache.pinot.core.segment.index.readers.ConstantValueLongDictionary;
import org.apache.pinot.core.segment.index.readers.ConstantValueStringDictionary;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.constant.ConstantMVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.constant.ConstantMVInvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.constant.ConstantSortedIndexReader;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.spi.data.FieldSpec;

public class DefaultNullValueVirtualColumnProvider
extends BaseVirtualColumnProvider {
    @Override
    public ForwardIndexReader<?> buildForwardIndex(VirtualColumnContext context) {
        if (context.getFieldSpec().isSingleValueField()) {
            return new ConstantSortedIndexReader(context.getTotalDocCount());
        }
        return new ConstantMVForwardIndexReader();
    }

    @Override
    public Dictionary buildDictionary(VirtualColumnContext context) {
        FieldSpec fieldSpec = context.getFieldSpec();
        switch (fieldSpec.getDataType()) {
            case INT: {
                return new ConstantValueIntDictionary((Integer)fieldSpec.getDefaultNullValue());
            }
            case LONG: {
                return new ConstantValueLongDictionary((Long)fieldSpec.getDefaultNullValue());
            }
            case FLOAT: {
                return new ConstantValueFloatDictionary(((Float)fieldSpec.getDefaultNullValue()).floatValue());
            }
            case DOUBLE: {
                return new ConstantValueDoubleDictionary((Double)fieldSpec.getDefaultNullValue());
            }
            case STRING: {
                return new ConstantValueStringDictionary((String)fieldSpec.getDefaultNullValue());
            }
            case BYTES: {
                return new ConstantValueBytesDictionary((byte[])fieldSpec.getDefaultNullValue());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public InvertedIndexReader<?> buildInvertedIndex(VirtualColumnContext context) {
        if (context.getFieldSpec().isSingleValueField()) {
            return new ConstantSortedIndexReader(context.getTotalDocCount());
        }
        return new ConstantMVInvertedIndexReader(context.getTotalDocCount());
    }

    @Override
    public ColumnMetadata buildMetadata(VirtualColumnContext context) {
        return this.getColumnMetadataBuilder(context).setCardinality(1).setHasDictionary(true).setHasInvertedIndex(true).setIsSorted(context.getFieldSpec().isSingleValueField()).build();
    }
}

