/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.core.segment.creator.impl.stats.AbstractColumnStatisticsCollector;

public class StringColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private final ObjectSet<String> _values = new ObjectOpenHashSet(1000);
    private int _minLength = Integer.MAX_VALUE;
    private int _maxLength = 0;
    private String[] _sortedValues;
    private boolean _sealed = false;

    public StringColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                String value = (String)obj;
                this._values.add((Object)value);
                int length = StringUtil.encodeUtf8((String)value).length;
                this._minLength = Math.min(this._minLength, length);
                this._maxLength = Math.max(this._maxLength, length);
            }
            this.maxNumberOfMultiValues = Math.max(this.maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else {
            String value = (String)entry;
            this.addressSorted(value);
            this.updatePartition(value);
            this._values.add((Object)value);
            int valueLength = StringUtil.encodeUtf8((String)value).length;
            this._minLength = Math.min(this._minLength, valueLength);
            this._maxLength = Math.max(this._maxLength, valueLength);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public String getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public String getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    public Object[] getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getLengthOfLargestElement() {
        if (this._sealed) {
            return this._maxLength;
        }
        throw new IllegalStateException("you must seal the collector first before asking for longest value");
    }

    @Override
    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this._sortedValues = (String[])this._values.toArray((Object[])new String[this._values.size()]);
        Arrays.sort(this._sortedValues);
        this._sealed = true;
    }
}

