/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.inv;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.segment.creator.DictionaryBasedInvertedIndexCreator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class OnHeapBitmapInvertedIndexCreator
implements DictionaryBasedInvertedIndexCreator {
    private final File _invertedIndexFile;
    private final MutableRoaringBitmap[] _bitmaps;
    private int _nextDocId;

    public OnHeapBitmapInvertedIndexCreator(File indexDir, String columnName, int cardinality) {
        this._invertedIndexFile = new File(indexDir, columnName + ".bitmap.inv");
        this._bitmaps = new MutableRoaringBitmap[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            this._bitmaps[i] = new MutableRoaringBitmap();
        }
    }

    @Override
    public void add(int dictId) {
        this._bitmaps[dictId].add(this._nextDocId++);
    }

    @Override
    public void add(int[] dictIds, int length) {
        for (int i = 0; i < length; ++i) {
            this._bitmaps[dictIds[i]].add(this._nextDocId);
        }
        ++this._nextDocId;
    }

    @Override
    public void seal() throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._invertedIndexFile)));){
            int bitmapOffset = (this._bitmaps.length + 1) * 4;
            out.writeInt(bitmapOffset);
            for (MutableRoaringBitmap bitmap : this._bitmaps) {
                Preconditions.checkState(((bitmapOffset += bitmap.serializedSizeInBytes()) > 0 ? 1 : 0) != 0, (String)"Inverted index file: %s exceeds 2GB limit", (Object)this._invertedIndexFile);
                out.writeInt(bitmapOffset);
            }
            for (MutableRoaringBitmap bitmap : this._bitmaps) {
                bitmap.serialize((DataOutput)out);
            }
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)this._invertedIndexFile);
            throw e;
        }
    }

    @Override
    public void close() {
    }
}

