/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.inv;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.core.segment.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class OffHeapBitmapInvertedIndexCreator
implements DictionaryBasedInvertedIndexCreator {
    private static final int NUM_VALUES_THRESHOLD_FOR_MMAP_BUFFER = 500000000;
    private static final String FORWARD_INDEX_VALUE_BUFFER_SUFFIX = ".fwd.idx.val.buf";
    private static final String FORWARD_INDEX_LENGTH_BUFFER_SUFFIX = ".fwd.idx.len.buf";
    private static final String INVERTED_INDEX_VALUE_BUFFER_SUFFIX = ".inv.idx.val.buf";
    private static final String INVERTED_INDEX_LENGTH_BUFFER_SUFFIX = ".inv.idx.len.buf";
    private final File _invertedIndexFile;
    private final File _forwardIndexValueBufferFile;
    private final File _forwardIndexLengthBufferFile;
    private final File _invertedIndexValueBufferFile;
    private final File _invertedIndexLengthBufferFile;
    private final boolean _singleValue;
    private final int _cardinality;
    private final int _numDocs;
    private final int _numValues;
    private final boolean _useMMapBuffer;
    private int _nextDocId;
    private PinotDataBuffer _forwardIndexValueBuffer;
    private int _nextValueId;
    private PinotDataBuffer _forwardIndexLengthBuffer;
    private PinotDataBuffer _invertedIndexValueBuffer;
    private PinotDataBuffer _invertedIndexLengthBuffer;

    public OffHeapBitmapInvertedIndexCreator(File indexDir, FieldSpec fieldSpec, int cardinality, int numDocs, int numValues) throws IOException {
        String columnName = fieldSpec.getName();
        this._invertedIndexFile = new File(indexDir, columnName + ".bitmap.inv");
        this._forwardIndexValueBufferFile = new File(indexDir, columnName + FORWARD_INDEX_VALUE_BUFFER_SUFFIX);
        this._forwardIndexLengthBufferFile = new File(indexDir, columnName + FORWARD_INDEX_LENGTH_BUFFER_SUFFIX);
        this._invertedIndexValueBufferFile = new File(indexDir, columnName + INVERTED_INDEX_VALUE_BUFFER_SUFFIX);
        this._invertedIndexLengthBufferFile = new File(indexDir, columnName + INVERTED_INDEX_LENGTH_BUFFER_SUFFIX);
        this._singleValue = fieldSpec.isSingleValueField();
        this._cardinality = cardinality;
        this._numDocs = numDocs;
        this._numValues = this._singleValue ? numDocs : numValues;
        this._useMMapBuffer = this._numValues > 500000000;
        try {
            this._forwardIndexValueBuffer = this.createTempBuffer((long)this._numValues * 4L, this._forwardIndexValueBufferFile);
            if (!this._singleValue) {
                this._forwardIndexLengthBuffer = this.createTempBuffer((long)this._numDocs * 4L, this._forwardIndexLengthBufferFile);
            }
            this._invertedIndexLengthBuffer = this.createTempBuffer((long)this._cardinality * 4L, this._invertedIndexLengthBufferFile);
            for (int i = 0; i < this._cardinality; ++i) {
                this._invertedIndexLengthBuffer.putInt((long)i * 4L, 0);
            }
        }
        catch (Exception e) {
            this.destroyBuffer(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile);
            this.destroyBuffer(this._forwardIndexLengthBuffer, this._forwardIndexLengthBufferFile);
            this.destroyBuffer(this._invertedIndexLengthBuffer, this._invertedIndexLengthBufferFile);
            throw e;
        }
    }

    @Override
    public void add(int dictId) {
        OffHeapBitmapInvertedIndexCreator.putInt(this._forwardIndexValueBuffer, this._nextDocId++, dictId);
        OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexLengthBuffer, dictId, OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexLengthBuffer, dictId) + 1);
    }

    @Override
    public void add(int[] dictIds, int length) {
        for (int i = 0; i < length; ++i) {
            int dictId = dictIds[i];
            OffHeapBitmapInvertedIndexCreator.putInt(this._forwardIndexValueBuffer, this._nextValueId++, dictId);
            OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexLengthBuffer, dictId, OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexLengthBuffer, dictId) + 1);
        }
        OffHeapBitmapInvertedIndexCreator.putInt(this._forwardIndexLengthBuffer, this._nextDocId++, length);
    }

    @Override
    public void seal() throws IOException {
        int invertedValueIndex = 0;
        for (int dictId = 0; dictId < this._cardinality; ++dictId) {
            int length = OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexLengthBuffer, dictId);
            OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexLengthBuffer, dictId, invertedValueIndex);
            invertedValueIndex += length;
        }
        this._invertedIndexValueBuffer = this.createTempBuffer((long)this._numValues * 4L, this._invertedIndexValueBufferFile);
        if (this._singleValue) {
            for (int docId = 0; docId < this._numDocs; ++docId) {
                int dictId = OffHeapBitmapInvertedIndexCreator.getInt(this._forwardIndexValueBuffer, docId);
                int index = OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexLengthBuffer, dictId);
                OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexValueBuffer, index, docId);
                OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexLengthBuffer, dictId, index + 1);
            }
            this.destroyBuffer(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile);
            this._forwardIndexValueBuffer = null;
        } else {
            int valueId = 0;
            for (int docId = 0; docId < this._numDocs; ++docId) {
                int length = OffHeapBitmapInvertedIndexCreator.getInt(this._forwardIndexLengthBuffer, docId);
                for (int i = 0; i < length; ++i) {
                    int dictId = OffHeapBitmapInvertedIndexCreator.getInt(this._forwardIndexValueBuffer, valueId++);
                    int index = OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexLengthBuffer, dictId);
                    OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexValueBuffer, index, docId);
                    OffHeapBitmapInvertedIndexCreator.putInt(this._invertedIndexLengthBuffer, dictId, index + 1);
                }
            }
            this.destroyBuffer(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile);
            this._forwardIndexValueBuffer = null;
            this.destroyBuffer(this._forwardIndexLengthBuffer, this._forwardIndexLengthBufferFile);
            this._forwardIndexLengthBuffer = null;
        }
        try (DataOutputStream offsetDataStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this._invertedIndexFile)));
             FileOutputStream bitmapFileStream = new FileOutputStream(this._invertedIndexFile);
             DataOutputStream bitmapDataStream = new DataOutputStream(new BufferedOutputStream(bitmapFileStream));){
            int bitmapOffset = (this._cardinality + 1) * 4;
            offsetDataStream.writeInt(bitmapOffset);
            bitmapFileStream.getChannel().position(bitmapOffset);
            int startIndex = 0;
            for (int dictId = 0; dictId < this._cardinality; ++dictId) {
                MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
                int endIndex = OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexLengthBuffer, dictId);
                for (int i = startIndex; i < endIndex; ++i) {
                    bitmap.add(OffHeapBitmapInvertedIndexCreator.getInt(this._invertedIndexValueBuffer, i));
                }
                startIndex = endIndex;
                Preconditions.checkState(((bitmapOffset += bitmap.serializedSizeInBytes()) > 0 ? 1 : 0) != 0, (String)"Inverted index file: %s exceeds 2GB limit", (Object)this._invertedIndexFile);
                offsetDataStream.writeInt(bitmapOffset);
                bitmap.serialize((DataOutput)bitmapDataStream);
            }
        }
        catch (Exception e) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)this._invertedIndexFile);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Closeable[])new Closeable[]{new DataBufferAndFile(this._forwardIndexValueBuffer, this._forwardIndexValueBufferFile), new DataBufferAndFile(this._forwardIndexLengthBuffer, this._forwardIndexLengthBufferFile), new DataBufferAndFile(this._invertedIndexValueBuffer, this._invertedIndexValueBufferFile), new DataBufferAndFile(this._invertedIndexLengthBuffer, this._invertedIndexLengthBufferFile)});
    }

    private static void putInt(PinotDataBuffer buffer, long index, int value) {
        buffer.putInt(index << 2, value);
    }

    private static int getInt(PinotDataBuffer buffer, long index) {
        return buffer.getInt(index << 2);
    }

    private PinotDataBuffer createTempBuffer(long size, File mmapFile) throws IOException {
        if (this._useMMapBuffer) {
            return PinotDataBuffer.mapFile(mmapFile, false, 0L, size, PinotDataBuffer.NATIVE_ORDER, "OffHeapBitmapInvertedIndexCreator: temp buffer");
        }
        return PinotDataBuffer.allocateDirect(size, PinotDataBuffer.NATIVE_ORDER, "OffHeapBitmapInvertedIndexCreator: temp buffer for " + mmapFile.getName());
    }

    private void destroyBuffer(PinotDataBuffer buffer, File mmapFile) throws IOException {
        if (buffer != null) {
            buffer.close();
            if (mmapFile.exists()) {
                org.apache.commons.io.FileUtils.forceDelete((File)mmapFile);
            }
        }
    }

    private class DataBufferAndFile
    implements Closeable {
        private final PinotDataBuffer _dataBuffer;
        private final File _file;

        DataBufferAndFile(PinotDataBuffer buffer, File file) {
            this._dataBuffer = buffer;
            this._file = file;
        }

        @Override
        public void close() throws IOException {
            OffHeapBitmapInvertedIndexCreator.this.destroyBuffer(this._dataBuffer, this._file);
        }
    }
}

