/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.fwd;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.core.io.writer.impl.VarByteChunkSVForwardIndexWriter;
import org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueVarByteRawIndexCreator
implements ForwardIndexCreator {
    private static final int DEFAULT_NUM_DOCS_PER_CHUNK = 1000;
    private static final int TARGET_MAX_CHUNK_SIZE = 0x100000;
    private final VarByteChunkSVForwardIndexWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressorFactory.CompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxLength) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, maxLength, false, 2);
    }

    public SingleValueVarByteRawIndexCreator(File baseIndexDir, ChunkCompressorFactory.CompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int maxLength, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        int numDocsPerChunk = deriveNumDocsPerChunk ? SingleValueVarByteRawIndexCreator.getNumDocsPerChunk(maxLength) : 1000;
        this._indexWriter = new VarByteChunkSVForwardIndexWriter(file, compressionType, totalDocs, numDocsPerChunk, maxLength, writerVersion);
        this._valueType = valueType;
    }

    @VisibleForTesting
    public static int getNumDocsPerChunk(int lengthOfLongestEntry) {
        int overheadPerEntry = lengthOfLongestEntry + 4;
        return Math.max(0x100000 / overheadPerEntry, 1);
    }

    @Override
    public boolean isDictionaryEncoded() {
        return false;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    @Override
    public void putString(String value) {
        this._indexWriter.putString(value);
    }

    @Override
    public void putBytes(byte[] value) {
        this._indexWriter.putBytes(value);
    }

    @Override
    public void close() throws IOException {
        this._indexWriter.close();
    }
}

