/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.core.io.util.PinotDataBitSet;
import org.apache.pinot.core.io.writer.impl.FixedBitSVForwardIndexWriter;
import org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueUnsortedForwardIndexCreator
implements ForwardIndexCreator {
    private final FixedBitSVForwardIndexWriter _writer;

    public SingleValueUnsortedForwardIndexCreator(File outputDir, String column, int cardinality, int numDocs) throws Exception {
        File indexFile = new File(outputDir, column + ".sv.unsorted.fwd");
        this._writer = new FixedBitSVForwardIndexWriter(indexFile, numDocs, PinotDataBitSet.getNumBitsPerValue(cardinality - 1));
    }

    @Override
    public boolean isDictionaryEncoded() {
        return true;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    @Override
    public void putDictId(int dictId) {
        this._writer.putDictId(dictId);
    }

    @Override
    public void close() throws IOException {
        this._writer.close();
    }
}

