/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.core.io.writer.impl.FixedByteChunkSVForwardIndexWriter;
import org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueFixedByteRawIndexCreator
implements ForwardIndexCreator {
    private static final int NUM_DOCS_PER_CHUNK = 1000;
    private final FixedByteChunkSVForwardIndexWriter _indexWriter;
    private final FieldSpec.DataType _valueType;

    public SingleValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressorFactory.CompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType) throws IOException {
        this(baseIndexDir, compressionType, column, totalDocs, valueType, 2);
    }

    public SingleValueFixedByteRawIndexCreator(File baseIndexDir, ChunkCompressorFactory.CompressionType compressionType, String column, int totalDocs, FieldSpec.DataType valueType, int writerVersion) throws IOException {
        File file = new File(baseIndexDir, column + ".sv.raw.fwd");
        this._indexWriter = new FixedByteChunkSVForwardIndexWriter(file, compressionType, totalDocs, 1000, valueType.size(), writerVersion);
        this._valueType = valueType;
    }

    @Override
    public boolean isDictionaryEncoded() {
        return false;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    @Override
    public void putInt(int value) {
        this._indexWriter.putInt(value);
    }

    @Override
    public void putLong(long value) {
        this._indexWriter.putLong(value);
    }

    @Override
    public void putFloat(float value) {
        this._indexWriter.putFloat(value);
    }

    @Override
    public void putDouble(double value) {
        this._indexWriter.putDouble(value);
    }

    @Override
    public void close() throws IOException {
        this._indexWriter.close();
    }
}

