/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.core.io.util.PinotDataBitSet;
import org.apache.pinot.core.io.writer.impl.FixedBitMVForwardIndexWriter;
import org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class MultiValueUnsortedForwardIndexCreator
implements ForwardIndexCreator {
    private final FixedBitMVForwardIndexWriter _writer;

    public MultiValueUnsortedForwardIndexCreator(File outputDir, String column, int cardinality, int numDocs, int totalNumValues) throws Exception {
        File indexFile = new File(outputDir, column + ".mv.fwd");
        this._writer = new FixedBitMVForwardIndexWriter(indexFile, numDocs, totalNumValues, PinotDataBitSet.getNumBitsPerValue(cardinality - 1));
    }

    @Override
    public boolean isDictionaryEncoded() {
        return true;
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    @Override
    public void putDictIdMV(int[] dictIds) {
        this._writer.putDictIds(dictIds);
    }

    @Override
    public void close() throws IOException {
        this._writer.close();
    }
}

