/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.indexsegment.generator.SegmentGeneratorConfig;
import org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.core.io.util.PinotDataBitSet;
import org.apache.pinot.core.segment.creator.ColumnIndexCreationInfo;
import org.apache.pinot.core.segment.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.core.segment.creator.ForwardIndexCreator;
import org.apache.pinot.core.segment.creator.SegmentCreator;
import org.apache.pinot.core.segment.creator.SegmentIndexCreationInfo;
import org.apache.pinot.core.segment.creator.TextIndexCreator;
import org.apache.pinot.core.segment.creator.TextIndexType;
import org.apache.pinot.core.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.core.segment.creator.impl.V1Constants;
import org.apache.pinot.core.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.core.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.core.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.core.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.core.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.core.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.core.segment.creator.impl.inv.OnHeapBitmapInvertedIndexCreator;
import org.apache.pinot.core.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.core.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentColumnarIndexCreator
implements SegmentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentColumnarIndexCreator.class);
    private static final int METADATA_PROPERTY_LENGTH_LIMIT = 512;
    private SegmentGeneratorConfig config;
    private Map<String, ColumnIndexCreationInfo> indexCreationInfoMap;
    private Map<String, SegmentDictionaryCreator> _dictionaryCreatorMap = new HashMap<String, SegmentDictionaryCreator>();
    private Map<String, ForwardIndexCreator> _forwardIndexCreatorMap = new HashMap<String, ForwardIndexCreator>();
    private Map<String, DictionaryBasedInvertedIndexCreator> _invertedIndexCreatorMap = new HashMap<String, DictionaryBasedInvertedIndexCreator>();
    private Map<String, TextIndexCreator> _textIndexCreatorMap = new HashMap<String, TextIndexCreator>();
    private Map<String, NullValueVectorCreator> _nullValueVectorCreatorMap = new HashMap<String, NullValueVectorCreator>();
    private String segmentName;
    private Schema schema;
    private File _indexDir;
    private int totalDocs;
    private int docIdCounter;
    private boolean _nullHandlingEnabled;
    private final Set<String> _textIndexColumns = new HashSet<String>();

    @Override
    public void init(SegmentGeneratorConfig segmentCreationSpec, SegmentIndexCreationInfo segmentIndexCreationInfo, Map<String, ColumnIndexCreationInfo> indexCreationInfoMap, Schema schema, File outDir) throws Exception {
        this.docIdCounter = 0;
        this.config = segmentCreationSpec;
        this.indexCreationInfoMap = indexCreationInfoMap;
        Preconditions.checkState((!outDir.exists() ? 1 : 0) != 0, (String)"Segment output directory: %s already exists", (Object)outDir);
        Preconditions.checkState((boolean)outDir.mkdirs(), (String)"Failed to create output directory: %s", (Object)outDir);
        this._indexDir = outDir;
        this.schema = schema;
        this.totalDocs = segmentIndexCreationInfo.getTotalDocs();
        Collection fieldSpecs = schema.getAllFieldSpecs();
        HashSet<String> invertedIndexColumns = new HashSet<String>();
        for (String columnName : this.config.getInvertedIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn(columnName), (String)"Cannot create inverted index for column: %s because it is not in schema", (Object)columnName);
            invertedIndexColumns.add(columnName);
        }
        for (String columnName : this.config.getTextIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn(columnName), (String)"Cannot create text index for column: %s because it is not in schema", (Object)columnName);
            this._textIndexColumns.add(columnName);
        }
        for (FieldSpec fieldSpec : fieldSpecs) {
            if (fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            ColumnIndexCreationInfo indexCreationInfo = indexCreationInfoMap.get(columnName);
            Preconditions.checkNotNull((Object)indexCreationInfo, (String)"Missing index creation info for column: %s", (Object)columnName);
            if (this.createDictionaryForColumn(indexCreationInfo, segmentCreationSpec, fieldSpec)) {
                SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(indexCreationInfo.getSortedUniqueElementsArray(), fieldSpec, this._indexDir, indexCreationInfo.isUseVarLengthDictionary());
                this._dictionaryCreatorMap.put(columnName, dictionaryCreator);
                try {
                    dictionaryCreator.build();
                }
                catch (Exception e) {
                    LOGGER.error("Error building dictionary for field: {}, cardinality: {}, number of bytes per entry: {}", new Object[]{fieldSpec.getName(), indexCreationInfo.getDistinctValueCount(), dictionaryCreator.getNumBytesPerEntry()});
                    throw e;
                }
                int cardinality = indexCreationInfo.getDistinctValueCount();
                if (fieldSpec.isSingleValueField()) {
                    if (indexCreationInfo.isSorted()) {
                        this._forwardIndexCreatorMap.put(columnName, new SingleValueSortedForwardIndexCreator(this._indexDir, columnName, cardinality));
                    } else {
                        this._forwardIndexCreatorMap.put(columnName, new SingleValueUnsortedForwardIndexCreator(this._indexDir, columnName, cardinality, this.totalDocs));
                    }
                } else {
                    this._forwardIndexCreatorMap.put(columnName, new MultiValueUnsortedForwardIndexCreator(this._indexDir, columnName, cardinality, this.totalDocs, indexCreationInfo.getTotalNumberOfEntries()));
                }
                if (invertedIndexColumns.contains(columnName) && !indexCreationInfo.isSorted()) {
                    if (segmentCreationSpec.isOnHeap()) {
                        this._invertedIndexCreatorMap.put(columnName, new OnHeapBitmapInvertedIndexCreator(this._indexDir, columnName, cardinality));
                    } else {
                        this._invertedIndexCreatorMap.put(columnName, new OffHeapBitmapInvertedIndexCreator(this._indexDir, fieldSpec, cardinality, this.totalDocs, indexCreationInfo.getTotalNumberOfEntries()));
                    }
                }
            } else {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (String)"Cannot create raw index for multi-value column: %s", (Object)columnName);
                Preconditions.checkState((!invertedIndexColumns.contains(columnName) ? 1 : 0) != 0, (String)"Cannot create inverted index for raw index column: %s", (Object)columnName);
                ChunkCompressorFactory.CompressionType compressionType = this.getColumnCompressionType(segmentCreationSpec, fieldSpec);
                boolean deriveNumDocsPerChunk = SegmentColumnarIndexCreator.shouldDeriveNumDocsPerChunk(columnName, segmentCreationSpec.getColumnProperties());
                int writerVersion = SegmentColumnarIndexCreator.rawIndexWriterVersion(columnName, segmentCreationSpec.getColumnProperties());
                this._forwardIndexCreatorMap.put(columnName, SegmentColumnarIndexCreator.getRawIndexCreatorForColumn(this._indexDir, compressionType, columnName, fieldSpec.getDataType(), this.totalDocs, indexCreationInfo.getLengthOfLongestEntry(), deriveNumDocsPerChunk, writerVersion));
            }
            if (this._textIndexColumns.contains(columnName)) {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)"Text index is currently only supported on single-value columns");
                Preconditions.checkState((fieldSpec.getDataType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Text index is currently only supported on STRING type columns");
                this._textIndexCreatorMap.put(columnName, new LuceneTextIndexCreator(columnName, this._indexDir, true));
            }
            this._nullHandlingEnabled = this.config.isNullHandlingEnabled();
            if (!this._nullHandlingEnabled) continue;
            this._nullValueVectorCreatorMap.put(columnName, new NullValueVectorCreator(this._indexDir, columnName));
        }
    }

    public static boolean shouldDeriveNumDocsPerChunk(String columnName, Map<String, Map<String, String>> columnProperties) {
        if (columnProperties != null) {
            Map<String, String> properties = columnProperties.get(columnName);
            return properties != null && Boolean.parseBoolean(properties.get(FieldConfig.DERIVE_NUM_DOCS_PER_CHUNK_RAW_INDEX_KEY));
        }
        return false;
    }

    public static int rawIndexWriterVersion(String columnName, Map<String, Map<String, String>> columnProperties) {
        if (columnProperties != null && columnProperties.get(columnName) != null) {
            Map<String, String> properties = columnProperties.get(columnName);
            String version = properties.get(FieldConfig.RAW_INDEX_WRITER_VERSION);
            if (version == null) {
                return 2;
            }
            return Integer.parseInt(version);
        }
        return 2;
    }

    private ChunkCompressorFactory.CompressionType getColumnCompressionType(SegmentGeneratorConfig segmentCreationSpec, FieldSpec fieldSpec) {
        ChunkCompressorFactory.CompressionType compressionType = segmentCreationSpec.getRawIndexCompressionType().get(fieldSpec.getName());
        if (compressionType == null) {
            if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.METRIC)) {
                return ChunkCompressorFactory.CompressionType.PASS_THROUGH;
            }
            return ChunkCompressorFactory.CompressionType.SNAPPY;
        }
        return compressionType;
    }

    private boolean createDictionaryForColumn(ColumnIndexCreationInfo info, SegmentGeneratorConfig config, FieldSpec spec) {
        String column = spec.getName();
        if (config.getRawIndexCreationColumns().contains(column) || config.getRawIndexCompressionType().containsKey(column)) {
            if (!spec.isSingleValueField()) {
                throw new RuntimeException("Creation of indices without dictionaries is supported for single valued columns only.");
            }
            return false;
        }
        if (spec.getDataType().equals((Object)FieldSpec.DataType.BYTES) && !info.isFixedLength()) {
            return false;
        }
        return info.isCreateDictionary();
    }

    @Override
    public void indexRow(GenericRow row) {
        for (Map.Entry<String, ForwardIndexCreator> entry : this._forwardIndexCreatorMap.entrySet()) {
            DictionaryBasedInvertedIndexCreator invertedIndexCreator;
            String columnName = entry.getKey();
            ForwardIndexCreator forwardIndexCreator = entry.getValue();
            Object columnValueToIndex = row.getValue(columnName);
            if (columnValueToIndex == null) {
                throw new RuntimeException("Null value for column:" + columnName);
            }
            boolean isSingleValue = this.schema.getFieldSpecFor(columnName).isSingleValueField();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(columnName);
            if (isSingleValue) {
                if (dictionaryCreator != null) {
                    int dictId = dictionaryCreator.indexOfSV(columnValueToIndex);
                    forwardIndexCreator.putDictId(dictId);
                    invertedIndexCreator = this._invertedIndexCreatorMap.get(columnName);
                    if (invertedIndexCreator != null) {
                        invertedIndexCreator.add(dictId);
                    }
                } else {
                    switch (forwardIndexCreator.getValueType()) {
                        case INT: {
                            forwardIndexCreator.putInt((Integer)columnValueToIndex);
                            break;
                        }
                        case LONG: {
                            forwardIndexCreator.putLong((Long)columnValueToIndex);
                            break;
                        }
                        case FLOAT: {
                            forwardIndexCreator.putFloat(((Float)columnValueToIndex).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            forwardIndexCreator.putDouble((Double)columnValueToIndex);
                            break;
                        }
                        case STRING: {
                            forwardIndexCreator.putString((String)columnValueToIndex);
                            break;
                        }
                        case BYTES: {
                            forwardIndexCreator.putBytes((byte[])columnValueToIndex);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                if (this._textIndexColumns.contains(columnName)) {
                    this._textIndexCreatorMap.get(columnName).add((String)columnValueToIndex);
                }
            } else {
                int[] dictIds = dictionaryCreator.indexOfMV(columnValueToIndex);
                forwardIndexCreator.putDictIdMV(dictIds);
                invertedIndexCreator = this._invertedIndexCreatorMap.get(columnName);
                if (invertedIndexCreator != null) {
                    invertedIndexCreator.add(dictIds, dictIds.length);
                }
            }
            if (!this._nullHandlingEnabled || !row.isNullValue(columnName)) continue;
            this._nullValueVectorCreatorMap.get(columnName).setNull(this.docIdCounter);
        }
        ++this.docIdCounter;
    }

    @Override
    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    @Override
    public void seal() throws ConfigurationException, IOException {
        for (DictionaryBasedInvertedIndexCreator invertedIndexCreator : this._invertedIndexCreatorMap.values()) {
            invertedIndexCreator.seal();
        }
        for (TextIndexCreator textIndexCreator : this._textIndexCreatorMap.values()) {
            textIndexCreator.seal();
        }
        for (NullValueVectorCreator nullValueVectorCreator : this._nullValueVectorCreatorMap.values()) {
            nullValueVectorCreator.seal();
        }
        this.writeMetadata();
    }

    private void writeMetadata() throws ConfigurationException {
        ColumnIndexCreationInfo timeColumnIndexCreationInfo;
        PropertiesConfiguration properties = new PropertiesConfiguration(new File(this._indexDir, "metadata.properties"));
        properties.setProperty("creator.version", (Object)this.config.getCreatorVersion());
        properties.setProperty("segment.padding.character", (Object)String.valueOf('\u0000'));
        properties.setProperty("segment.name", (Object)this.segmentName);
        properties.setProperty("segment.table.name", (Object)this.config.getTableName());
        properties.setProperty("segment.dimension.column.names", (Object)this.config.getDimensions());
        properties.setProperty("segment.metric.column.names", (Object)this.config.getMetrics());
        properties.setProperty("segment.datetime.column.names", (Object)this.config.getDateTimeColumnNames());
        String timeColumnName = this.config.getTimeColumnName();
        properties.setProperty("segment.time.column.name", (Object)timeColumnName);
        properties.setProperty("segment.total.docs", (Object)String.valueOf(this.totalDocs));
        if (timeColumnName != null && (timeColumnIndexCreationInfo = this.indexCreationInfoMap.get(timeColumnName)) != null) {
            TimeUnit timeUnit;
            long endTime;
            long l;
            if (this.config.getStartTime() != null) {
                l = Long.parseLong(this.config.getStartTime());
                endTime = Long.parseLong(this.config.getEndTime());
                timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this.config.getSegmentTimeUnit())));
            } else {
                String startTimeStr = timeColumnIndexCreationInfo.getMin().toString();
                String endTimeStr = timeColumnIndexCreationInfo.getMax().toString();
                if (this.config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)this.config.getSimpleDateFormat());
                    l = dateTimeFormatter.parseMillis(startTimeStr);
                    endTime = dateTimeFormatter.parseMillis(endTimeStr);
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    l = Long.parseLong(startTimeStr);
                    endTime = Long.parseLong(endTimeStr);
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this.config.getSegmentTimeUnit())));
                }
            }
            if (!this.config.isSkipTimeValueCheck()) {
                Interval timeInterval = new Interval(timeUnit.toMillis(l), timeUnit.toMillis(endTime), DateTimeZone.UTC);
                Preconditions.checkState((boolean)TimeUtils.isValidTimeInterval((Interval)timeInterval), (String)"Invalid segment start/end time: %s (in millis: %s/%s) for time column: %s, must be between: %s", (Object[])new Object[]{timeInterval, timeInterval.getStartMillis(), timeInterval.getEndMillis(), timeColumnName, TimeUtils.VALID_TIME_INTERVAL});
            }
            properties.setProperty("segment.start.time", (Object)l);
            properties.setProperty("segment.end.time", (Object)endTime);
            properties.setProperty("segment.time.unit", (Object)timeUnit);
        }
        for (Map.Entry<String, String> entry : this.config.getCustomProperties().entrySet()) {
            properties.setProperty(entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.indexCreationInfoMap.entrySet()) {
            String column = entry.getKey();
            ColumnIndexCreationInfo columnIndexCreationInfo = (ColumnIndexCreationInfo)entry.getValue();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(column);
            int dictionaryElementSize = dictionaryCreator != null ? dictionaryCreator.getNumBytesPerEntry() : 0;
            boolean hasInvertedIndex = true;
            boolean hasTextIndex = this._textIndexColumns.contains(column);
            TextIndexType textIndexType = hasTextIndex ? TextIndexType.LUCENE : TextIndexType.NONE;
            SegmentColumnarIndexCreator.addColumnMetadataInfo(properties, column, columnIndexCreationInfo, this.totalDocs, this.schema.getFieldSpecFor(column), this._dictionaryCreatorMap.containsKey(column), dictionaryElementSize, hasInvertedIndex, textIndexType);
        }
        properties.save();
    }

    public static void addColumnMetadataInfo(PropertiesConfiguration properties, String column, ColumnIndexCreationInfo columnIndexCreationInfo, int totalDocs, FieldSpec fieldSpec, boolean hasDictionary, int dictionaryElementSize, boolean hasInvertedIndex, TextIndexType textIndexType) {
        String defaultNullValue;
        int cardinality = columnIndexCreationInfo.getDistinctValueCount();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "cardinality"), (Object)String.valueOf(cardinality));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "totalDocs"), (Object)String.valueOf(totalDocs));
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "dataType"), (Object)String.valueOf(dataType));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "bitsPerElement"), (Object)String.valueOf(PinotDataBitSet.getNumBitsPerValue(cardinality - 1)));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "lengthOfEachEntry"), (Object)String.valueOf(dictionaryElementSize));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "columnType"), (Object)String.valueOf(fieldSpec.getFieldType()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "isSorted"), (Object)String.valueOf(columnIndexCreationInfo.isSorted()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasNullValue"), (Object)String.valueOf(columnIndexCreationInfo.hasNulls()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasDictionary"), (Object)String.valueOf(hasDictionary));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "textIndexType"), (Object)textIndexType.name());
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasInvertedIndex"), (Object)String.valueOf(hasInvertedIndex));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "isSingleValues"), (Object)String.valueOf(fieldSpec.isSingleValueField()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "maxNumberOfMultiValues"), (Object)String.valueOf(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "totalNumberOfEntries"), (Object)String.valueOf(columnIndexCreationInfo.getTotalNumberOfEntries()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "isAutoGenerated"), (Object)String.valueOf(columnIndexCreationInfo.isAutoGenerated()));
        PartitionFunction partitionFunction = columnIndexCreationInfo.getPartitionFunction();
        if (partitionFunction != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionFunction"), (Object)partitionFunction.toString());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "numPartitions"), (Object)columnIndexCreationInfo.getNumPartitions());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionValues"), columnIndexCreationInfo.getPartitions());
        }
        if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.DATE_TIME)) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeFormat"), (Object)dateTimeFieldSpec.getFormat());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeGranularity"), (Object)dateTimeFieldSpec.getGranularity());
        }
        Object min = columnIndexCreationInfo.getMin();
        Object max = columnIndexCreationInfo.getMax();
        if (min != null && max != null) {
            SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(properties, column, min.toString(), max.toString());
        }
        if (SegmentColumnarIndexCreator.isValidPropertyValue(defaultNullValue = columnIndexCreationInfo.getDefaultNullValue().toString())) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "defaultNullValue"), (Object)defaultNullValue);
        }
    }

    public static void addColumnMinMaxValueInfo(PropertiesConfiguration properties, String column, String minValue, String maxValue) {
        if (SegmentColumnarIndexCreator.isValidPropertyValue(minValue)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "minValue"), (Object)minValue);
        }
        if (SegmentColumnarIndexCreator.isValidPropertyValue(maxValue)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "maxValue"), (Object)maxValue);
        }
    }

    @VisibleForTesting
    static boolean isValidPropertyValue(String value) {
        int length = value.length();
        if (length == 0) {
            return true;
        }
        if (length > 512) {
            return false;
        }
        if (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1))) {
            return false;
        }
        return value.indexOf(44) == -1;
    }

    public static void removeColumnMetadataInfo(PropertiesConfiguration properties, String column) {
        properties.subset("column." + column).clear();
    }

    public static ForwardIndexCreator getRawIndexCreatorForColumn(File file, ChunkCompressorFactory.CompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int lengthOfLongestEntry, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        switch (dataType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, writerVersion);
            }
            case STRING: 
            case BYTES: {
                return new SingleValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, lengthOfLongestEntry, deriveNumDocsPerChunk, writerVersion);
            }
        }
        throw new UnsupportedOperationException("Data type not supported for raw indexing: " + dataType);
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((Iterable)Iterables.concat((Iterable[])new Iterable[]{this._dictionaryCreatorMap.values(), this._forwardIndexCreatorMap.values(), this._invertedIndexCreatorMap.values(), this._textIndexCreatorMap.values(), this._nullValueVectorCreatorMap.values()}));
    }
}

