/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.data.partition.PartitionFunctionFactory;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class StatsCollectorConfig {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final SegmentPartitionConfig _segmentPartitionConfig;

    public StatsCollectorConfig(TableConfig tableConfig, Schema schema, @Nullable SegmentPartitionConfig segmentPartitionConfig) {
        Preconditions.checkNotNull((Object)tableConfig);
        Preconditions.checkNotNull((Object)schema);
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._segmentPartitionConfig = segmentPartitionConfig;
    }

    @Nullable
    public FieldSpec getFieldSpecForColumn(String column) {
        return this._schema.getFieldSpecFor(column);
    }

    @Nullable
    public PartitionFunction getPartitionFunction(String column) {
        if (this._segmentPartitionConfig == null) {
            return null;
        }
        String functionName = this._segmentPartitionConfig.getFunctionName(column);
        int numPartitions = this._segmentPartitionConfig.getNumPartitions(column);
        return functionName != null ? PartitionFunctionFactory.getPartitionFunction(functionName, numPartitions) : null;
    }

    public int getNumPartitions(String column) {
        return this._segmentPartitionConfig != null ? this._segmentPartitionConfig.getNumPartitions(column) : -1;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }
}

