/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator;

import java.util.Collection;
import org.apache.pinot.common.Utils;
import org.apache.pinot.core.data.recordtransformer.CompositeTransformer;
import org.apache.pinot.core.segment.creator.SegmentCreationDataSource;
import org.apache.pinot.core.segment.creator.SegmentPreIndexStatsCollector;
import org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.core.segment.creator.impl.stats.SegmentPreIndexStatsCollectorImpl;
import org.apache.pinot.core.util.IngestionUtils;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderSegmentCreationDataSource
implements SegmentCreationDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordReaderSegmentCreationDataSource.class);
    private final RecordReader _recordReader;

    public RecordReaderSegmentCreationDataSource(RecordReader recordReader) {
        this._recordReader = recordReader;
    }

    @Override
    public SegmentPreIndexStatsCollector gatherStats(StatsCollectorConfig statsCollectorConfig) {
        try {
            CompositeTransformer recordTransformer = CompositeTransformer.getDefaultTransformer(statsCollectorConfig.getTableConfig(), statsCollectorConfig.getSchema());
            SegmentPreIndexStatsCollectorImpl collector = new SegmentPreIndexStatsCollectorImpl(statsCollectorConfig);
            collector.init();
            GenericRow reuse = new GenericRow();
            while (this._recordReader.hasNext()) {
                reuse.clear();
                reuse = this._recordReader.next(reuse);
                if (reuse.getValue("$MULTIPLE_RECORDS_KEY$") != null) {
                    for (Object singleRow : (Collection)reuse.getValue("$MULTIPLE_RECORDS_KEY$")) {
                        GenericRow transformedRow = recordTransformer.transform((GenericRow)singleRow);
                        if (transformedRow == null || !IngestionUtils.shouldIngestRow(transformedRow)) continue;
                        collector.collectRow(transformedRow);
                    }
                    continue;
                }
                GenericRow transformedRow = recordTransformer.transform(reuse);
                if (transformedRow == null || !IngestionUtils.shouldIngestRow(transformedRow)) continue;
                collector.collectRow(transformedRow);
            }
            collector.build();
            return collector;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while gathering stats", (Throwable)e);
            Utils.rethrowException((Throwable)e);
            return null;
        }
    }

    @Override
    public RecordReader getRecordReader() {
        try {
            this._recordReader.rewind();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while rewinding record reader", (Throwable)e);
            Utils.rethrowException((Throwable)e);
        }
        return this._recordReader;
    }
}

