/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.creator;

import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.segment.creator.ColumnStatistics;

public class ColumnIndexCreationInfo {
    private final boolean createDictionary;
    private final boolean useVarLengthDictionary;
    private final boolean isAutoGenerated;
    private final Object defaultNullValue;
    private final ColumnStatistics columnStatistics;

    public ColumnIndexCreationInfo(ColumnStatistics columnStatistics, boolean createDictionary, boolean useVarLengthDictionary, boolean isAutoGenerated, Object defaultNullValue) {
        this.columnStatistics = columnStatistics;
        this.createDictionary = createDictionary;
        this.useVarLengthDictionary = useVarLengthDictionary;
        this.isAutoGenerated = isAutoGenerated;
        this.defaultNullValue = defaultNullValue;
    }

    public boolean isCreateDictionary() {
        return this.createDictionary;
    }

    public boolean isUseVarLengthDictionary() {
        return this.useVarLengthDictionary;
    }

    public Object getMin() {
        return this.columnStatistics.getMinValue();
    }

    public Object getMax() {
        return this.columnStatistics.getMaxValue();
    }

    public Object getSortedUniqueElementsArray() {
        return this.columnStatistics.getUniqueValuesSet();
    }

    public int getDistinctValueCount() {
        Object uniqueValArray = this.columnStatistics.getUniqueValuesSet();
        if (uniqueValArray == null) {
            return Integer.MIN_VALUE;
        }
        return ArrayUtils.getLength((Object)uniqueValArray);
    }

    public boolean isSorted() {
        return this.columnStatistics.isSorted();
    }

    public boolean hasNulls() {
        return this.columnStatistics.hasNull();
    }

    public int getTotalNumberOfEntries() {
        return this.columnStatistics.getTotalNumberOfEntries();
    }

    public int getMaxNumberOfMultiValueElements() {
        return this.columnStatistics.getMaxNumberOfMultiValues();
    }

    public boolean isAutoGenerated() {
        return this.isAutoGenerated;
    }

    public Object getDefaultNullValue() {
        return this.defaultNullValue;
    }

    public int getLengthOfLongestEntry() {
        return this.columnStatistics.getLengthOfLargestElement();
    }

    public Set<Integer> getPartitions() {
        return this.columnStatistics.getPartitions();
    }

    public PartitionFunction getPartitionFunction() {
        return this.columnStatistics.getPartitionFunction();
    }

    public int getNumPartitions() {
        return this.columnStatistics.getNumPartitions();
    }

    public boolean isFixedLength() {
        return this.columnStatistics.getLengthOfShortestElement() == this.columnStatistics.getLengthOfLargestElement();
    }
}

