/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.requesthandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.predicate.RangePredicate;
import org.apache.pinot.core.requesthandler.FilterQueryOptimizerRequest;
import org.apache.pinot.core.requesthandler.FilterQueryTreeOptimizer;

public class RangeMergeOptimizer
extends FilterQueryTreeOptimizer {
    private static final ExpressionContext DUMMY_EXPRESSION = ExpressionContext.forIdentifier("dummy");

    @Override
    public FilterQueryTree optimize(FilterQueryOptimizerRequest request) {
        return RangeMergeOptimizer.optimizeRanges(request.getFilterQueryTree(), request.getTimeColumn());
    }

    private static FilterQueryTree optimizeRanges(FilterQueryTree current, @Nullable String timeColumn) {
        if (timeColumn == null) {
            return current;
        }
        List children = current.getChildren();
        if (children == null || children.isEmpty()) {
            return current;
        }
        FilterOperator operator = current.getOperator();
        if (operator == FilterOperator.OR) {
            int length = children.size();
            for (int i = 0; i < length; ++i) {
                children.set(i, RangeMergeOptimizer.optimizeRanges((FilterQueryTree)children.get(i), timeColumn));
            }
            return current;
        }
        assert (operator == FilterOperator.AND);
        ArrayList<FilterQueryTree> newChildren = new ArrayList<FilterQueryTree>();
        String mergedRange = null;
        for (FilterQueryTree child : children) {
            FilterQueryTree newChild = RangeMergeOptimizer.optimizeRanges(child, timeColumn);
            if (newChild.getOperator() == FilterOperator.RANGE && newChild.getColumn().equals(timeColumn)) {
                String range = (String)newChild.getValue().get(0);
                if (mergedRange == null) {
                    mergedRange = range;
                    continue;
                }
                mergedRange = RangeMergeOptimizer.intersectRanges(mergedRange, range);
                continue;
            }
            newChildren.add(newChild);
        }
        FilterQueryTree rangeFilter = new FilterQueryTree(timeColumn, Collections.singletonList(mergedRange), FilterOperator.RANGE, null);
        if (newChildren.isEmpty()) {
            return rangeFilter;
        }
        if (mergedRange != null) {
            newChildren.add(rangeFilter);
        }
        return new FilterQueryTree(null, null, FilterOperator.AND, newChildren);
    }

    public static String intersectRanges(String range1, String range2) {
        RangePredicate predicate1 = new RangePredicate(DUMMY_EXPRESSION, range1);
        RangePredicate predicate2 = new RangePredicate(DUMMY_EXPRESSION, range2);
        StringBuilder stringBuilder = new StringBuilder();
        String lowerBound1 = predicate1.getLowerBound();
        String lowerBound2 = predicate2.getLowerBound();
        if (lowerBound1.equals("*")) {
            stringBuilder.append(predicate2.isLowerInclusive() ? (char)'[' : '(').append(lowerBound2);
        } else if (lowerBound2.equals("*")) {
            stringBuilder.append(predicate1.isLowerInclusive() ? (char)'[' : '(').append(lowerBound1);
        } else {
            long lowerValue2;
            long lowerValue1 = Long.parseLong(lowerBound1);
            if (lowerValue1 < (lowerValue2 = Long.parseLong(lowerBound2))) {
                stringBuilder.append(predicate2.isLowerInclusive() ? (char)'[' : '(').append(lowerBound2);
            } else if (lowerValue1 > lowerValue2) {
                stringBuilder.append(predicate1.isLowerInclusive() ? (char)'[' : '(').append(lowerBound1);
            } else {
                stringBuilder.append((char)(predicate1.isLowerInclusive() && predicate2.isLowerInclusive() ? 91 : 40)).append(lowerBound1);
            }
        }
        stringBuilder.append("\t\t");
        String upperBound1 = predicate1.getUpperBound();
        String upperBound2 = predicate2.getUpperBound();
        if (upperBound1.equals("*")) {
            stringBuilder.append(upperBound2).append(predicate2.isUpperInclusive() ? (char)']' : ')');
        } else if (upperBound2.equals("*")) {
            stringBuilder.append(upperBound1).append(predicate1.isUpperInclusive() ? (char)']' : ')');
        } else {
            long upperValue2;
            long upperValue1 = Long.parseLong(upperBound1);
            if (upperValue1 < (upperValue2 = Long.parseLong(upperBound2))) {
                stringBuilder.append(upperBound1).append(predicate1.isUpperInclusive() ? (char)']' : ')');
            } else if (upperValue1 > upperValue2) {
                stringBuilder.append(upperBound2).append(predicate2.isUpperInclusive() ? (char)']' : ')');
            } else {
                stringBuilder.append(upperBound1).append((char)(predicate1.isUpperInclusive() && predicate2.isUpperInclusive() ? 93 : 41));
            }
        }
        return stringBuilder.toString();
    }
}

