/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.requesthandler;

import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.core.requesthandler.PinotQueryRequest;
import org.apache.pinot.parsers.AbstractCompiler;
import org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public class PinotQueryParserFactory {
    private static final Pql2Compiler PQL_2_COMPILER = new Pql2Compiler();
    private static final CalciteSqlCompiler CALCITE_SQL_COMPILER = new CalciteSqlCompiler();

    public static AbstractCompiler get(String queryFormat) {
        switch (queryFormat.toLowerCase()) {
            case "pql": {
                return PQL_2_COMPILER;
            }
            case "sql": {
                return CALCITE_SQL_COMPILER;
            }
        }
        throw new UnsupportedOperationException("Unknown query format - " + queryFormat);
    }

    public static BrokerRequest parsePinotQueryRequest(PinotQueryRequest pinotQueryRequest) {
        return PinotQueryParserFactory.get(pinotQueryRequest.getQueryFormat()).compileToBrokerRequest(pinotQueryRequest.getQuery());
    }
}

