/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.requesthandler;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.BrokerRequest;

public class OptimizationFlags {
    private final Set<String> _enabledOptimizations;
    private final Set<String> _disabledOptimizations;

    private OptimizationFlags(Set<String> enabledOptimizations, Set<String> disabledOptimizations) {
        Preconditions.checkArgument((enabledOptimizations.isEmpty() || disabledOptimizations.isEmpty() ? 1 : 0) != 0, (Object)"Cannot exclude and include optimizations at the same time");
        this._enabledOptimizations = enabledOptimizations;
        this._disabledOptimizations = disabledOptimizations;
    }

    public boolean isOptimizationEnabled(String optimizationName) {
        if (this._enabledOptimizations.isEmpty()) {
            return !this._disabledOptimizations.contains(optimizationName);
        }
        return this._enabledOptimizations.contains(optimizationName);
    }

    @Nullable
    public static OptimizationFlags getOptimizationFlags(BrokerRequest brokerRequest) {
        if (brokerRequest == null || brokerRequest.getDebugOptions() == null) {
            return null;
        }
        String optimizationFlagString = (String)brokerRequest.getDebugOptions().get("optimizationFlags");
        if (optimizationFlagString == null || optimizationFlagString.isEmpty()) {
            return null;
        }
        HashSet<String> enabledOptimizations = new HashSet<String>();
        HashSet<String> disabledOptimizations = new HashSet<String>();
        List optimizations = Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)optimizationFlagString);
        for (String optimization : optimizations) {
            if (optimization.charAt(0) == '+') {
                enabledOptimizations.add(optimization.substring(1));
                continue;
            }
            if (optimization.charAt(0) == '-') {
                disabledOptimizations.add(optimization.substring(1));
                continue;
            }
            throw new RuntimeException("Optimization flag list contains an invalid value " + optimization + ", should be prefixed either with + or -");
        }
        return new OptimizationFlags(enabledOptimizations, disabledOptimizations);
    }

    public static String optimizationName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        String shortenedClassName = className.replaceAll("FilterQueryTreeOptimizer", "");
        return Character.toLowerCase(shortenedClassName.charAt(0)) + shortenedClassName.substring(1);
    }
}

