/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.requesthandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.core.requesthandler.FilterQueryOptimizerRequest;
import org.apache.pinot.core.requesthandler.FilterQueryTreeOptimizer;

public class MultipleOrEqualitiesToInClauseFilterQueryTreeOptimizer
extends FilterQueryTreeOptimizer {
    @Override
    public FilterQueryTree optimize(FilterQueryOptimizerRequest request) {
        return this.optimize(request.getFilterQueryTree());
    }

    private FilterQueryTree optimize(FilterQueryTree filterQueryTree) {
        if (filterQueryTree.getOperator() == FilterOperator.OR) {
            return this.optimizeTreeRootedAtOR(filterQueryTree);
        }
        if (filterQueryTree.getOperator() == FilterOperator.AND) {
            return this.optimizeTreeRootedAtAND(filterQueryTree);
        }
        if (filterQueryTree.getOperator() == FilterOperator.IN) {
            ArrayList values = filterQueryTree.getValue();
            if (values.size() > 1) {
                HashSet deduped = new HashSet(values);
                values = new ArrayList(deduped);
                if (deduped.size() > 1) {
                    return new FilterQueryTree(filterQueryTree.getColumn(), values, FilterOperator.IN, null);
                }
                return new FilterQueryTree(filterQueryTree.getColumn(), values, FilterOperator.EQUALITY, null);
            }
            return new FilterQueryTree(filterQueryTree.getColumn(), (List)values, FilterOperator.EQUALITY, null);
        }
        return filterQueryTree;
    }

    private FilterQueryTree optimizeTreeRootedAtOR(FilterQueryTree filterQueryTree) {
        HashMap<String, Set<String>> columnToInEqPredicateValues = new HashMap<String, Set<String>>();
        ArrayList<FilterQueryTree> nonEqInOperators = new ArrayList<FilterQueryTree>();
        boolean rewriteINEQChildrenOfORRootOperator = this.collectChildOperatorsOfRootOROperator(filterQueryTree, columnToInEqPredicateValues, nonEqInOperators);
        if (columnToInEqPredicateValues.size() == 1 && nonEqInOperators.isEmpty()) {
            Map.Entry columnAndValues = columnToInEqPredicateValues.entrySet().iterator().next();
            return this.buildFilterQueryTreeForColumnAndPredicateInfo((String)columnAndValues.getKey(), (Set)columnAndValues.getValue());
        }
        if (!rewriteINEQChildrenOfORRootOperator) {
            return filterQueryTree;
        }
        FilterQueryTree optimizedRoot = this.rebuildFilterPredicate(columnToInEqPredicateValues);
        optimizedRoot.getChildren().addAll(nonEqInOperators);
        return optimizedRoot;
    }

    private FilterQueryTree optimizeTreeRootedAtAND(FilterQueryTree filterQueryTree) {
        List children = filterQueryTree.getChildren();
        int numChildren = children.size();
        for (int i = 0; i < numChildren; ++i) {
            FilterQueryTree childQueryTree = (FilterQueryTree)children.get(i);
            children.set(i, this.optimize(childQueryTree));
        }
        return filterQueryTree;
    }

    private boolean collectChildOperatorsOfRootOROperator(FilterQueryTree filterQueryTree, Map<String, Set<String>> columnToInEqPredicateValues, List<FilterQueryTree> nonEqInOperators) {
        boolean rewriteINEQChildrenOfORRootOperator = false;
        for (FilterQueryTree childQueryTree : filterQueryTree.getChildren()) {
            FilterOperator operator = childQueryTree.getOperator();
            if (operator == FilterOperator.EQUALITY || operator == FilterOperator.IN) {
                List childValues = childQueryTree.getValue();
                String column = childQueryTree.getColumn();
                Set<String> predicateValues = columnToInEqPredicateValues.get(column);
                if (predicateValues == null) {
                    predicateValues = new HashSet<String>(childValues);
                    int numChildren = childValues.size();
                    if (operator == FilterOperator.IN && (numChildren == 1 || numChildren != predicateValues.size())) {
                        rewriteINEQChildrenOfORRootOperator = true;
                    }
                    columnToInEqPredicateValues.put(column, predicateValues);
                    continue;
                }
                predicateValues.addAll(childValues);
                rewriteINEQChildrenOfORRootOperator = true;
                continue;
            }
            if (childQueryTree.getOperator() == FilterOperator.AND) {
                nonEqInOperators.add(this.optimizeTreeRootedAtAND(childQueryTree));
                continue;
            }
            nonEqInOperators.add(childQueryTree);
        }
        return rewriteINEQChildrenOfORRootOperator;
    }

    private FilterQueryTree rebuildFilterPredicate(Map<String, Set<String>> columnToInEqPredicateValues) {
        ArrayList<FilterQueryTree> newChildren = new ArrayList<FilterQueryTree>();
        for (Map.Entry<String, Set<String>> columnAndPredicate : columnToInEqPredicateValues.entrySet()) {
            newChildren.add(this.buildFilterQueryTreeForColumnAndPredicateInfo(columnAndPredicate.getKey(), columnAndPredicate.getValue()));
        }
        return new FilterQueryTree(null, null, FilterOperator.OR, newChildren);
    }

    private FilterQueryTree buildFilterQueryTreeForColumnAndPredicateInfo(String column, Set<String> predicateValues) {
        ArrayList<String> values = new ArrayList<String>(predicateValues);
        if (predicateValues.size() == 1) {
            return new FilterQueryTree(column, values, FilterOperator.EQUALITY, null);
        }
        return new FilterQueryTree(column, values, FilterOperator.IN, null);
    }
}

