/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.requesthandler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.core.requesthandler.FilterQueryOptimizerRequest;
import org.apache.pinot.core.requesthandler.FilterQueryTreeOptimizer;

public class FlattenNestedPredicatesFilterQueryTreeOptimizer
extends FilterQueryTreeOptimizer {
    public static int MAX_OPTIMIZING_DEPTH = 5;

    @Override
    public FilterQueryTree optimize(FilterQueryOptimizerRequest request) {
        FilterQueryTree filterQueryTree = request.getFilterQueryTree();
        this.flatten(filterQueryTree, null, MAX_OPTIMIZING_DEPTH);
        return filterQueryTree;
    }

    private void flatten(FilterQueryTree node, FilterQueryTree parent, int maxDepth) {
        if (node == null || node.getChildren() == null || maxDepth == 0) {
            return;
        }
        ArrayList<FilterQueryTree> toFlatten = new ArrayList<FilterQueryTree>(node.getChildren().size());
        for (FilterQueryTree child : node.getChildren()) {
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            toFlatten.add(child);
        }
        for (FilterQueryTree child : toFlatten) {
            this.flatten(child, node, maxDepth - 1);
        }
        if (parent == null) {
            return;
        }
        if (node.getOperator() == parent.getOperator() && (node.getOperator() == FilterOperator.OR || node.getOperator() == FilterOperator.AND)) {
            List children = node.getChildren();
            Iterator it = children.iterator();
            int insertIdx = parent.getChildren().indexOf(node);
            while (it.hasNext()) {
                parent.getChildren().add(insertIdx++, it.next());
                it.remove();
            }
            parent.getChildren().remove(node);
        }
    }
}

