/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.requesthandler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.FilterQuery;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.requesthandler.FilterQueryOptimizerRequest;
import org.apache.pinot.core.requesthandler.FilterQueryTreeOptimizer;
import org.apache.pinot.core.requesthandler.FlattenNestedPredicatesFilterQueryTreeOptimizer;
import org.apache.pinot.core.requesthandler.MultipleOrEqualitiesToInClauseFilterQueryTreeOptimizer;
import org.apache.pinot.core.requesthandler.OptimizationFlags;
import org.apache.pinot.core.requesthandler.RangeMergeOptimizer;

public class BrokerRequestOptimizer {
    private static final List<? extends FilterQueryTreeOptimizer> FILTER_QUERY_TREE_OPTIMIZERS = Arrays.asList(new FlattenNestedPredicatesFilterQueryTreeOptimizer(), new MultipleOrEqualitiesToInClauseFilterQueryTreeOptimizer(), new RangeMergeOptimizer());

    public BrokerRequest optimize(BrokerRequest brokerRequest, String timeColumn) {
        OptimizationFlags optimizationFlags = OptimizationFlags.getOptimizationFlags(brokerRequest);
        this.optimizeFilterQueryTree(brokerRequest, timeColumn, optimizationFlags);
        return brokerRequest;
    }

    private void optimizeFilterQueryTree(BrokerRequest brokerRequest, String timeColumn, OptimizationFlags optimizationFlags) {
        FilterQueryTree filterQueryTree = null;
        FilterQuery q = brokerRequest.getFilterQuery();
        if (q == null || brokerRequest.getFilterSubQueryMap() == null) {
            return;
        }
        filterQueryTree = RequestUtils.buildFilterQuery((Integer)q.getId(), (Map)brokerRequest.getFilterSubQueryMap().getFilterQueryMap());
        FilterQueryOptimizerRequest.FilterQueryOptimizerRequestBuilder builder = new FilterQueryOptimizerRequest.FilterQueryOptimizerRequestBuilder();
        FilterQueryOptimizerRequest request = builder.setFilterQueryTree(filterQueryTree).setTimeColumn(timeColumn).build();
        if (optimizationFlags == null) {
            for (FilterQueryTreeOptimizer filterQueryTreeOptimizer : FILTER_QUERY_TREE_OPTIMIZERS) {
                filterQueryTree = filterQueryTreeOptimizer.optimize(request);
                request.setFilterQueryTree(filterQueryTree);
            }
        } else if (optimizationFlags.isOptimizationEnabled("filterQueryTree")) {
            for (FilterQueryTreeOptimizer filterQueryTreeOptimizer : FILTER_QUERY_TREE_OPTIMIZERS) {
                if (!optimizationFlags.isOptimizationEnabled(filterQueryTreeOptimizer.getOptimizationName())) continue;
                filterQueryTree = filterQueryTreeOptimizer.optimize(request);
                request.setFilterQueryTree(filterQueryTree);
            }
        }
        RequestUtils.generateFilterFromTree((FilterQueryTree)filterQueryTree, (BrokerRequest)brokerRequest);
    }
}

