/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.impl.dictionary;

import org.apache.pinot.core.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.core.realtime.impl.dictionary.BytesOffHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.BytesOnHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.DoubleOffHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.DoubleOnHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.FloatOffHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.FloatOnHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.IntOffHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.IntOnHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.LongOffHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.LongOnHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.StringOffHeapMutableDictionary;
import org.apache.pinot.core.realtime.impl.dictionary.StringOnHeapMutableDictionary;
import org.apache.pinot.core.segment.index.readers.MutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class MutableDictionaryFactory {
    private MutableDictionaryFactory() {
    }

    public static MutableDictionary getMutableDictionary(FieldSpec.DataType dataType, boolean isOffHeapAllocation, PinotDataBufferMemoryManager memoryManager, int avgLength, int cardinality, String allocationContext) {
        if (isOffHeapAllocation) {
            int maxOverflowSize = cardinality / 10;
            switch (dataType) {
                case INT: {
                    return new IntOffHeapMutableDictionary(cardinality, maxOverflowSize, memoryManager, allocationContext);
                }
                case LONG: {
                    return new LongOffHeapMutableDictionary(cardinality, maxOverflowSize, memoryManager, allocationContext);
                }
                case FLOAT: {
                    return new FloatOffHeapMutableDictionary(cardinality, maxOverflowSize, memoryManager, allocationContext);
                }
                case DOUBLE: {
                    return new DoubleOffHeapMutableDictionary(cardinality, maxOverflowSize, memoryManager, allocationContext);
                }
                case STRING: {
                    return new StringOffHeapMutableDictionary(cardinality, maxOverflowSize, memoryManager, allocationContext, avgLength);
                }
                case BYTES: {
                    return new BytesOffHeapMutableDictionary(cardinality, maxOverflowSize, memoryManager, allocationContext, avgLength);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (dataType) {
            case INT: {
                return new IntOnHeapMutableDictionary();
            }
            case LONG: {
                return new LongOnHeapMutableDictionary();
            }
            case FLOAT: {
                return new FloatOnHeapMutableDictionary();
            }
            case DOUBLE: {
                return new DoubleOnHeapMutableDictionary();
            }
            case STRING: {
                return new StringOnHeapMutableDictionary();
            }
            case BYTES: {
                return new BytesOnHeapMutableDictionary();
            }
        }
        throw new UnsupportedOperationException();
    }
}

