/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Arrays;
import org.apache.pinot.core.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class BytesOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private volatile byte[] _min = null;
    private volatile byte[] _max = null;

    @Override
    public int index(Object value) {
        byte[] bytesValue = (byte[])value;
        this.updateMinMax(bytesValue);
        return this.indexValue(new ByteArray(bytesValue));
    }

    @Override
    public int[] index(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(int dictId1, int dictId2) {
        return ByteArray.compare((byte[])this.getBytesValue(dictId1), (byte[])this.getBytesValue(dictId2));
    }

    @Override
    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int upperCompareThreshold;
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        int lowerCompareThreshold = includeLower ? 0 : 1;
        int n = upperCompareThreshold = includeUpper ? 0 : -1;
        if (lower.equals("*")) {
            byte[] upperValue = BytesUtils.toBytes((String)upper);
            for (int dictId = 0; dictId < numValues; ++dictId) {
                byte[] value = this.getBytesValue(dictId);
                if (ByteArray.compare((byte[])value, (byte[])upperValue) > upperCompareThreshold) continue;
                dictIds.add(dictId);
            }
        } else if (upper.equals("*")) {
            byte[] lowerValue = BytesUtils.toBytes((String)lower);
            for (int dictId = 0; dictId < numValues; ++dictId) {
                byte[] value = this.getBytesValue(dictId);
                if (ByteArray.compare((byte[])value, (byte[])lowerValue) < lowerCompareThreshold) continue;
                dictIds.add(dictId);
            }
        } else {
            byte[] lowerValue = BytesUtils.toBytes((String)lower);
            byte[] upperValue = BytesUtils.toBytes((String)upper);
            for (int dictId = 0; dictId < numValues; ++dictId) {
                byte[] value = this.getBytesValue(dictId);
                if (ByteArray.compare((byte[])value, (byte[])lowerValue) < lowerCompareThreshold || ByteArray.compare((byte[])value, (byte[])upperValue) > upperCompareThreshold) continue;
                dictIds.add(dictId);
            }
        }
        return dictIds;
    }

    public ByteArray getMinVal() {
        return new ByteArray(this._min);
    }

    public ByteArray getMaxVal() {
        return new ByteArray(this._max);
    }

    public ByteArray[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new ByteArray[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getByteArrayValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    @Override
    public int indexOf(String stringValue) {
        return this.getDictId(BytesUtils.toByteArray((String)stringValue));
    }

    public byte[] get(int dictId) {
        return this.getBytesValue(dictId);
    }

    @Override
    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this.getBytesValue(dictId));
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return this.getByteArrayValue(dictId).getBytes();
    }

    private void updateMinMax(byte[] value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (ByteArray.compare((byte[])value, (byte[])this._min) < 0) {
                this._min = value;
            }
            if (ByteArray.compare((byte[])value, (byte[])this._max) > 0) {
                this._max = value;
            }
        }
    }

    private ByteArray getByteArrayValue(int dictId) {
        return (ByteArray)super.get(dictId);
    }
}

