/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.converter.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.core.realtime.converter.RealtimeSegmentRecordReader;
import org.apache.pinot.core.realtime.converter.stats.RealtimeColumnStatistics;
import org.apache.pinot.core.realtime.converter.stats.RealtimeNoDictionaryColStatistics;
import org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.core.segment.creator.SegmentPreIndexStatsContainer;

public class RealtimeSegmentStatsContainer
implements SegmentPreIndexStatsContainer {
    private final MutableSegmentImpl _realtimeSegment;
    private final Map<String, ColumnStatistics> _columnStatisticsMap = new HashMap<String, ColumnStatistics>();

    public RealtimeSegmentStatsContainer(MutableSegmentImpl realtimeSegment, RealtimeSegmentRecordReader realtimeSegmentRecordReader) {
        this._realtimeSegment = realtimeSegment;
        for (String columnName : realtimeSegment.getPhysicalColumnNames()) {
            DataSource dataSource = realtimeSegment.getDataSource(columnName);
            if (dataSource.getDictionary() != null) {
                this._columnStatisticsMap.put(columnName, new RealtimeColumnStatistics(realtimeSegment.getDataSource(columnName), realtimeSegmentRecordReader.getSortedDocIdIterationOrder()));
                continue;
            }
            this._columnStatisticsMap.put(columnName, new RealtimeNoDictionaryColStatistics(dataSource));
        }
    }

    @Override
    public ColumnStatistics getColumnProfileFor(String column) {
        return this._columnStatisticsMap.get(column);
    }

    @Override
    public int getTotalDocCount() {
        return this._realtimeSegment.getNumDocsIndexed();
    }
}

