/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.converter.stats;

import org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.core.realtime.converter.RealtimeSegmentRecordReader;
import org.apache.pinot.core.realtime.converter.stats.RealtimeSegmentStatsContainer;
import org.apache.pinot.core.segment.creator.SegmentCreationDataSource;
import org.apache.pinot.core.segment.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.core.segment.creator.StatsCollectorConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;

public class RealtimeSegmentSegmentCreationDataSource
implements SegmentCreationDataSource {
    private final MutableSegmentImpl _realtimeSegment;
    private final RealtimeSegmentRecordReader _realtimeSegmentRecordReader;
    private final Schema _schema;

    public RealtimeSegmentSegmentCreationDataSource(MutableSegmentImpl realtimeSegment, RealtimeSegmentRecordReader realtimeSegmentRecordReader, Schema schema) {
        this._realtimeSegment = realtimeSegment;
        this._realtimeSegmentRecordReader = realtimeSegmentRecordReader;
        this._schema = schema;
    }

    @Override
    public SegmentPreIndexStatsContainer gatherStats(StatsCollectorConfig statsCollectorConfig) {
        if (!statsCollectorConfig.getSchema().equals((Object)this._schema)) {
            throw new RuntimeException("Incompatible schemas used for conversion and extraction");
        }
        return new RealtimeSegmentStatsContainer(this._realtimeSegment, this._realtimeSegmentRecordReader);
    }

    @Override
    public RecordReader getRecordReader() {
        return this._realtimeSegmentRecordReader;
    }
}

