/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.converter.stats;

import java.util.Set;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.core.segment.index.readers.MutableForwardIndex;

public class RealtimeNoDictionaryColStatistics
implements ColumnStatistics {
    private final DataSourceMetadata _dataSourceMetadata;
    private final MutableForwardIndex _forwardIndex;

    public RealtimeNoDictionaryColStatistics(DataSource dataSource) {
        this._dataSourceMetadata = dataSource.getDataSourceMetadata();
        this._forwardIndex = (MutableForwardIndex)dataSource.getForwardIndex();
    }

    @Override
    public Object getMinValue() {
        return this._dataSourceMetadata.getMinValue();
    }

    @Override
    public Object getMaxValue() {
        return this._dataSourceMetadata.getMaxValue();
    }

    @Override
    public Object getUniqueValuesSet() {
        return null;
    }

    @Override
    public int getCardinality() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getLengthOfShortestElement() {
        return this._forwardIndex.getLengthOfShortestElement();
    }

    @Override
    public int getLengthOfLargestElement() {
        return this._forwardIndex.getLengthOfLongestElement();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public int getTotalNumberOfEntries() {
        return this._dataSourceMetadata.getNumDocs();
    }

    @Override
    public int getMaxNumberOfMultiValues() {
        return 0;
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public PartitionFunction getPartitionFunction() {
        return this._dataSourceMetadata.getPartitionFunction();
    }

    @Override
    public int getNumPartitions() {
        PartitionFunction partitionFunction = this._dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            return partitionFunction.getNumPartitions();
        }
        return 0;
    }

    @Override
    public Set<Integer> getPartitions() {
        return this._dataSourceMetadata.getPartitions();
    }
}

