/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.converter.stats;

import java.util.Set;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.segment.creator.ColumnStatistics;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.MutableForwardIndex;
import org.apache.pinot.spi.data.FieldSpec;

public class RealtimeColumnStatistics
implements ColumnStatistics {
    private final DataSource _dataSource;
    private final int[] _sortedDocIdIterationOrder;
    private final Dictionary _dictionary;

    public RealtimeColumnStatistics(DataSource dataSource, int[] sortedDocIdIterationOrder) {
        this._dataSource = dataSource;
        this._sortedDocIdIterationOrder = sortedDocIdIterationOrder;
        this._dictionary = dataSource.getDictionary();
    }

    @Override
    public Object getMinValue() {
        return this._dictionary.getMinVal();
    }

    @Override
    public Object getMaxValue() {
        return this._dictionary.getMaxVal();
    }

    @Override
    public Object getUniqueValuesSet() {
        return this._dictionary.getSortedValues();
    }

    @Override
    public int getCardinality() {
        return this._dictionary.length();
    }

    @Override
    public int getLengthOfShortestElement() {
        int minStringLength;
        block3: {
            int length;
            FieldSpec.DataType dataType;
            block2: {
                minStringLength = Integer.MAX_VALUE;
                dataType = this._dataSource.getDataSourceMetadata().getDataType();
                length = this._dictionary.length();
                if (!dataType.equals((Object)FieldSpec.DataType.STRING)) break block2;
                for (int i = 0; i < length; ++i) {
                    minStringLength = Math.min(this._dictionary.getStringValue(i).length(), minStringLength);
                }
                break block3;
            }
            if (!dataType.equals((Object)FieldSpec.DataType.BYTES)) break block3;
            for (int i = 0; i < length; ++i) {
                minStringLength = Math.min(this._dictionary.getBytesValue(i).length, minStringLength);
            }
        }
        return minStringLength;
    }

    @Override
    public int getLengthOfLargestElement() {
        int maximumStringLength;
        block3: {
            int length;
            FieldSpec.DataType dataType;
            block2: {
                maximumStringLength = 0;
                dataType = this._dataSource.getDataSourceMetadata().getDataType();
                length = this._dictionary.length();
                if (!dataType.equals((Object)FieldSpec.DataType.STRING)) break block2;
                for (int i = 0; i < length; ++i) {
                    maximumStringLength = Math.max(this._dictionary.getStringValue(i).length(), maximumStringLength);
                }
                break block3;
            }
            if (!dataType.equals((Object)FieldSpec.DataType.BYTES)) break block3;
            for (int i = 0; i < length; ++i) {
                maximumStringLength = Math.max(this._dictionary.getBytesValue(i).length, maximumStringLength);
            }
        }
        return maximumStringLength;
    }

    @Override
    public boolean isSorted() {
        DataSourceMetadata dataSourceMetadata = this._dataSource.getDataSourceMetadata();
        if (!dataSourceMetadata.isSingleValue()) {
            return false;
        }
        if (this.getCardinality() == 1) {
            return true;
        }
        MutableForwardIndex mutableForwardIndex = (MutableForwardIndex)this._dataSource.getForwardIndex();
        int numDocs = dataSourceMetadata.getNumDocs();
        if (this._sortedDocIdIterationOrder != null) {
            int previousDictId = mutableForwardIndex.getDictId(this._sortedDocIdIterationOrder[0]);
            for (int i = 1; i < numDocs; ++i) {
                int currentDictId = mutableForwardIndex.getDictId(this._sortedDocIdIterationOrder[i]);
                if (this._dictionary.compare(previousDictId, currentDictId) > 0) {
                    return false;
                }
                previousDictId = currentDictId;
            }
        } else {
            int previousDictId = mutableForwardIndex.getDictId(0);
            for (int i = 1; i < numDocs; ++i) {
                int currentDictId = mutableForwardIndex.getDictId(i);
                if (this._dictionary.compare(previousDictId, currentDictId) > 0) {
                    return false;
                }
                previousDictId = currentDictId;
            }
        }
        return true;
    }

    @Override
    public int getTotalNumberOfEntries() {
        return this._dataSource.getDataSourceMetadata().getNumValues();
    }

    @Override
    public int getMaxNumberOfMultiValues() {
        return this._dataSource.getDataSourceMetadata().getMaxNumValuesPerMVEntry();
    }

    @Override
    public boolean hasNull() {
        return false;
    }

    @Override
    public PartitionFunction getPartitionFunction() {
        return this._dataSource.getDataSourceMetadata().getPartitionFunction();
    }

    @Override
    public int getNumPartitions() {
        PartitionFunction partitionFunction = this._dataSource.getDataSourceMetadata().getPartitionFunction();
        if (partitionFunction != null) {
            return partitionFunction.getNumPartitions();
        }
        return 0;
    }

    @Override
    public Set<Integer> getPartitions() {
        return this._dataSource.getDataSourceMetadata().getPartitions();
    }
}

