/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.realtime.converter;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.indexsegment.mutable.MutableSegmentImpl;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class RealtimeSegmentRecordReader
implements RecordReader {
    private final MutableSegmentImpl _realtimeSegment;
    private final int _numDocs;
    private final int[] _sortedDocIdIterationOrder;
    private int _nextDocId = 0;

    public RealtimeSegmentRecordReader(MutableSegmentImpl realtimeSegment, @Nullable String sortedColumn) {
        this._realtimeSegment = realtimeSegment;
        this._numDocs = realtimeSegment.getNumDocsIndexed();
        this._sortedDocIdIterationOrder = sortedColumn != null ? realtimeSegment.getSortedDocIdIterationOrderWithSortedColumn(sortedColumn) : null;
    }

    public int[] getSortedDocIdIterationOrder() {
        return this._sortedDocIdIterationOrder;
    }

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) {
    }

    public boolean hasNext() {
        return this._nextDocId < this._numDocs;
    }

    public GenericRow next() {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) {
        if (this._sortedDocIdIterationOrder == null) {
            return this._realtimeSegment.getRecord(this._nextDocId++, reuse);
        }
        return this._realtimeSegment.getRecord(this._sortedDocIdIterationOrder[this._nextDocId++], reuse);
    }

    public void rewind() {
        this._nextDocId = 0;
    }

    public void close() {
    }
}

