/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;

public class SelectionOperatorService {
    private final List<String> _selectionColumns;
    private final DataSchema _dataSchema;
    private final int _offset;
    private final int _numRowsToKeep;
    private final PriorityQueue<Object[]> _rows;

    public SelectionOperatorService(QueryContext queryContext, DataSchema dataSchema) {
        this._selectionColumns = SelectionOperatorUtils.getSelectionColumns(queryContext.getSelectExpressions(), dataSchema);
        this._dataSchema = dataSchema;
        this._offset = queryContext.getOffset();
        this._numRowsToKeep = this._offset + queryContext.getLimit();
        assert (queryContext.getOrderByExpressions() != null);
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), this.getTypeCompatibleComparator(queryContext.getOrderByExpressions()));
    }

    private Comparator<Object[]> getTypeCompatibleComparator(List<OrderByExpressionContext> orderByExpressions) {
        int numOrderByExpressions = orderByExpressions.size();
        ArrayList<Integer> valueIndexList = new ArrayList<Integer>(numOrderByExpressions);
        for (int i = 0; i < numOrderByExpressions; ++i) {
            if (this._dataSchema.getColumnDataType(i).isArray()) continue;
            valueIndexList.add(i);
        }
        int numValuesToCompare = valueIndexList.size();
        int[] valueIndices = new int[numValuesToCompare];
        boolean[] isNumber = new boolean[numValuesToCompare];
        int[] multipliers = new int[numValuesToCompare];
        for (int i = 0; i < numValuesToCompare; ++i) {
            int valueIndex;
            valueIndices[i] = valueIndex = ((Integer)valueIndexList.get(i)).intValue();
            isNumber[i] = this._dataSchema.getColumnDataType(valueIndex).isNumber();
            multipliers[i] = orderByExpressions.get(valueIndex).isAsc() ? -1 : 1;
        }
        return (o1, o2) -> {
            for (int i = 0; i < numValuesToCompare; ++i) {
                int index = valueIndices[i];
                Object v1 = o1[index];
                Object v2 = o2[index];
                int result = isNumber[i] ? Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue()) : ((Comparable)v1).compareTo(v2);
                if (result == 0) continue;
                return result * multipliers[i];
            }
            return 0;
        };
    }

    public PriorityQueue<Object[]> getRows() {
        return this._rows;
    }

    public void reduceWithOrdering(Collection<DataTable> dataTables) {
        for (DataTable dataTable : dataTables) {
            int numRows = dataTable.getNumberOfRows();
            for (int rowId = 0; rowId < numRows; ++rowId) {
                Object[] row = SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId);
                SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
            }
        }
    }

    public SelectionResults renderSelectionResultsWithOrdering(boolean preserveType) {
        LinkedList<Serializable[]> rowsInSelectionResults = new LinkedList<Serializable[]>();
        int[] columnIndices = SelectionOperatorUtils.getColumnIndices(this._selectionColumns, this._dataSchema);
        int numColumns = columnIndices.length;
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        if (preserveType) {
            while (this._rows.size() > this._offset) {
                Object[] row = this._rows.poll();
                assert (row != null);
                Serializable[] extractedRow = new Serializable[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    int columnIndex = columnIndices[i];
                    extractedRow[i] = SelectionOperatorUtils.convertValueToType(row[columnIndex], columnDataTypes[columnIndex]);
                }
                rowsInSelectionResults.addFirst(extractedRow);
            }
        } else {
            while (this._rows.size() > this._offset) {
                Object[] row = this._rows.poll();
                assert (row != null);
                Serializable[] extractedRow = new Serializable[numColumns];
                for (int i = 0; i < numColumns; ++i) {
                    int columnIndex = columnIndices[i];
                    extractedRow[i] = SelectionOperatorUtils.getFormattedValue(row[columnIndex], columnDataTypes[columnIndex]);
                }
                rowsInSelectionResults.addFirst(extractedRow);
            }
        }
        return new SelectionResults(this._selectionColumns, rowsInSelectionResults);
    }

    public ResultTable renderResultTableWithOrdering() {
        LinkedList<Object[]> rowsInSelectionResults = new LinkedList<Object[]>();
        int[] columnIndices = SelectionOperatorUtils.getColumnIndices(this._selectionColumns, this._dataSchema);
        int numColumns = columnIndices.length;
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        while (this._rows.size() > this._offset) {
            Object[] row = this._rows.poll();
            assert (row != null);
            Object[] extractedRow = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                int columnIndex = columnIndices[i];
                extractedRow[i] = SelectionOperatorUtils.convertValueToType(row[columnIndex], columnDataTypes[columnIndex]);
            }
            rowsInSelectionResults.addFirst(extractedRow);
        }
        String[] columnNames = this._dataSchema.getColumnNames();
        String[] resultColumnNames = new String[numColumns];
        DataSchema.ColumnDataType[] resultColumnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            int columnIndex = columnIndices[i];
            resultColumnNames[i] = columnNames[columnIndex];
            resultColumnDataTypes[i] = columnDataTypes[columnIndex];
        }
        DataSchema resultDataSchema = new DataSchema(resultColumnNames, resultColumnDataTypes);
        return new ResultTable(resultDataSchema, rowsInSelectionResults);
    }
}

