/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.core.query.scheduler.resources.QueryExecutorService;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManager {
    private static final Logger LOGGER;
    public static final String QUERY_RUNNER_CONFIG_KEY = "query_runner_threads";
    public static final String QUERY_WORKER_CONFIG_KEY = "query_worker_threads";
    public static final int DEFAULT_QUERY_RUNNER_THREADS;
    public static final int DEFAULT_QUERY_WORKER_THREADS;
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    protected final ListeningExecutorService queryRunners;
    protected final ListeningExecutorService queryWorkers;
    protected final int numQueryRunnerThreads;
    protected final int numQueryWorkerThreads;

    public ResourceManager(PinotConfiguration config) {
        this.numQueryRunnerThreads = config.getProperty(QUERY_RUNNER_CONFIG_KEY, DEFAULT_QUERY_RUNNER_THREADS);
        this.numQueryWorkerThreads = config.getProperty(QUERY_WORKER_CONFIG_KEY, DEFAULT_QUERY_WORKER_THREADS);
        LOGGER.info("Initializing with {} query runner threads and {} worker threads", (Object)this.numQueryRunnerThreads, (Object)this.numQueryWorkerThreads);
        ThreadFactory queryRunnerFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat("pqr-%d").build();
        this.queryRunners = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.numQueryRunnerThreads, queryRunnerFactory));
        ThreadFactory queryWorkersFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(5).setNameFormat("pqw-%d").build();
        this.queryWorkers = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.numQueryWorkerThreads, queryWorkersFactory));
    }

    public void stop() {
        this.queryWorkers.shutdownNow();
        this.queryRunners.shutdownNow();
    }

    public final int getNumQueryRunnerThreads() {
        return this.numQueryRunnerThreads;
    }

    public final int getNumQueryWorkerThreads() {
        return this.numQueryWorkerThreads;
    }

    public final ListeningExecutorService getQueryRunners() {
        return this.queryRunners;
    }

    @VisibleForTesting
    public final ExecutorService getQueryWorkers() {
        return this.queryWorkers;
    }

    public abstract QueryExecutorService getExecutorService(ServerQueryRequest var1, SchedulerGroupAccountant var2);

    public abstract int getTableThreadsHardLimit();

    public abstract int getTableThreadsSoftLimit();

    public boolean canSchedule(SchedulerGroupAccountant accountant) {
        return accountant.totalReservedThreads() < this.getTableThreadsHardLimit();
    }

    static {
        int numCores;
        LOGGER = LoggerFactory.getLogger(ResourceManager.class);
        DEFAULT_QUERY_RUNNER_THREADS = numCores = Runtime.getRuntime().availableProcessors();
        DEFAULT_QUERY_WORKER_THREADS = 2 * numCores;
    }
}

