/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;

public class SchedulerQueryContext {
    private final ServerQueryRequest queryRequest;
    private final SettableFuture<byte[]> resultFuture;
    private SchedulerGroup schedulerGroup;

    public SchedulerQueryContext(@Nonnull ServerQueryRequest queryRequest) {
        Preconditions.checkNotNull((Object)queryRequest);
        this.queryRequest = queryRequest;
        this.resultFuture = SettableFuture.create();
    }

    @Nonnull
    public ServerQueryRequest getQueryRequest() {
        return this.queryRequest;
    }

    @Nonnull
    public SettableFuture<byte[]> getResultFuture() {
        return this.resultFuture;
    }

    public void setResultFuture(ListenableFuture<byte[]> f) {
        this.resultFuture.setFuture(f);
    }

    public void setSchedulerGroupContext(SchedulerGroup schedulerGroup) {
        this.schedulerGroup = schedulerGroup;
    }

    @Nullable
    public SchedulerGroup getSchedulerGroup() {
        return this.schedulerGroup;
    }

    public long getArrivalTimeMs() {
        return this.queryRequest.getTimerContext().getQueryArrivalTimeMs();
    }
}

