/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.function.FunctionDefinitionRegistry;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.FunctionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.predicate.EqPredicate;
import org.apache.pinot.core.query.request.context.predicate.InPredicate;
import org.apache.pinot.core.query.request.context.predicate.IsNotNullPredicate;
import org.apache.pinot.core.query.request.context.predicate.IsNullPredicate;
import org.apache.pinot.core.query.request.context.predicate.NotEqPredicate;
import org.apache.pinot.core.query.request.context.predicate.NotInPredicate;
import org.apache.pinot.core.query.request.context.predicate.RangePredicate;
import org.apache.pinot.core.query.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.core.query.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.pql.parsers.pql2.ast.AstNode;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.pql.parsers.pql2.ast.FunctionCallAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.IdentifierAstNode;
import org.apache.pinot.pql.parsers.pql2.ast.LiteralAstNode;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public class QueryContextConverterUtils {
    private static final Pql2Compiler PQL_COMPILER = new Pql2Compiler();
    private static final CalciteSqlCompiler SQL_COMPILER = new CalciteSqlCompiler();

    private QueryContextConverterUtils() {
    }

    public static QueryContext getQueryContextFromPQL(String pqlQuery) {
        return BrokerRequestToQueryContextConverter.convert(PQL_COMPILER.compileToBrokerRequest(pqlQuery));
    }

    public static QueryContext getQueryContextFromSQL(String sqlQuery) {
        return BrokerRequestToQueryContextConverter.convert(SQL_COMPILER.compileToBrokerRequest(sqlQuery));
    }

    public static ExpressionContext getExpression(Expression thriftExpression) {
        switch (thriftExpression.getType()) {
            case LITERAL: {
                return ExpressionContext.forLiteral(thriftExpression.getLiteral().getFieldValue().toString());
            }
            case IDENTIFIER: {
                return ExpressionContext.forIdentifier(thriftExpression.getIdentifier().getName());
            }
            case FUNCTION: {
                return ExpressionContext.forFunction(QueryContextConverterUtils.getFunction(thriftExpression.getFunctionCall()));
            }
        }
        throw new IllegalStateException();
    }

    public static ExpressionContext getExpression(String stringExpression) {
        if (stringExpression.equals("*")) {
            return ExpressionContext.forIdentifier("*");
        }
        return QueryContextConverterUtils.getExpression(PQL_COMPILER.parseToAstNode(stringExpression));
    }

    public static ExpressionContext getExpression(AstNode astNode) {
        if (astNode instanceof IdentifierAstNode) {
            return ExpressionContext.forIdentifier(((IdentifierAstNode)astNode).getName());
        }
        if (astNode instanceof FunctionCallAstNode) {
            return ExpressionContext.forFunction(QueryContextConverterUtils.getFunction((FunctionCallAstNode)astNode));
        }
        if (astNode instanceof LiteralAstNode) {
            return ExpressionContext.forLiteral(((LiteralAstNode)astNode).getValueAsString());
        }
        throw new IllegalStateException();
    }

    public static FunctionContext getFunction(Function thriftFunction) {
        String functionName = thriftFunction.getOperator();
        if (functionName.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
            return new FunctionContext(FunctionContext.Type.AGGREGATION, AggregationFunctionType.COUNT.getName(), Collections.singletonList(ExpressionContext.forIdentifier("*")));
        }
        FunctionContext.Type functionType = FunctionDefinitionRegistry.isAggFunc((String)functionName) ? FunctionContext.Type.AGGREGATION : FunctionContext.Type.TRANSFORM;
        List operands = thriftFunction.getOperands();
        ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(operands.size());
        for (Expression operand : operands) {
            arguments.add(QueryContextConverterUtils.getExpression(operand));
        }
        return new FunctionContext(functionType, functionName, arguments);
    }

    public static FunctionContext getFunction(FunctionCallAstNode astNode) {
        String functionName = astNode.getName();
        if (functionName.equalsIgnoreCase(AggregationFunctionType.COUNT.getName())) {
            return new FunctionContext(FunctionContext.Type.AGGREGATION, AggregationFunctionType.COUNT.getName(), Collections.singletonList(ExpressionContext.forIdentifier("*")));
        }
        FunctionContext.Type functionType = FunctionDefinitionRegistry.isAggFunc((String)functionName) ? FunctionContext.Type.AGGREGATION : FunctionContext.Type.TRANSFORM;
        List children = astNode.getChildren();
        ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(children.size());
        for (AstNode child : children) {
            arguments.add(QueryContextConverterUtils.getExpression(child));
        }
        return new FunctionContext(functionType, functionName, arguments);
    }

    public static FilterContext getFilter(Expression thriftExpression) {
        Function thriftFunction = thriftExpression.getFunctionCall();
        FilterKind filterKind = FilterKind.valueOf((String)thriftFunction.getOperator().toUpperCase());
        List operands = thriftFunction.getOperands();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    children.add(QueryContextConverterUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    children.add(QueryContextConverterUtils.getFilter(operand));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case NOT_EQUALS: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(QueryContextConverterUtils.getStringValue((Expression)operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(QueryContextConverterUtils.getStringValue((Expression)operands.get(i)));
                }
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), values));
            }
            case GREATER_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), false, QueryContextConverterUtils.getStringValue((Expression)operands.get(1)), false, "*"));
            }
            case GREATER_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), true, QueryContextConverterUtils.getStringValue((Expression)operands.get(1)), false, "*"));
            }
            case LESS_THAN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), false, "*", false, QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case LESS_THAN_OR_EQUAL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), false, "*", true, QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case BETWEEN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), true, QueryContextConverterUtils.getStringValue((Expression)operands.get(1)), true, QueryContextConverterUtils.getStringValue((Expression)operands.get(2))));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0)), QueryContextConverterUtils.getStringValue((Expression)operands.get(1))));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0))));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(QueryContextConverterUtils.getExpression((Expression)operands.get(0))));
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringValue(Expression thriftExpression) {
        if (thriftExpression.getType() != ExpressionType.LITERAL) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return thriftExpression.getLiteral().getFieldValue().toString();
    }

    public static FilterContext getFilter(FilterQueryTree node) {
        FilterOperator filterOperator = node.getOperator();
        switch (filterOperator) {
            case AND: {
                List childNodes = node.getChildren();
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(childNodes.size());
                for (FilterQueryTree childNode : childNodes) {
                    children.add(QueryContextConverterUtils.getFilter(childNode));
                }
                return new FilterContext(FilterContext.Type.AND, children, null);
            }
            case OR: {
                List childNodes = node.getChildren();
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(childNodes.size());
                for (FilterQueryTree childNode : childNodes) {
                    children.add(QueryContextConverterUtils.getFilter(childNode));
                }
                return new FilterContext(FilterContext.Type.OR, children, null);
            }
            case EQUALITY: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new EqPredicate(QueryContextConverterUtils.getExpression(node.getColumn()), (String)node.getValue().get(0)));
            }
            case NOT: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotEqPredicate(QueryContextConverterUtils.getExpression(node.getColumn()), (String)node.getValue().get(0)));
            }
            case IN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new InPredicate(QueryContextConverterUtils.getExpression(node.getColumn()), node.getValue()));
            }
            case NOT_IN: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new NotInPredicate(QueryContextConverterUtils.getExpression(node.getColumn()), node.getValue()));
            }
            case RANGE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RangePredicate(QueryContextConverterUtils.getExpression(node.getColumn()), (String)node.getValue().get(0)));
            }
            case REGEXP_LIKE: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new RegexpLikePredicate(QueryContextConverterUtils.getExpression(node.getColumn()), (String)node.getValue().get(0)));
            }
            case TEXT_MATCH: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new TextMatchPredicate(QueryContextConverterUtils.getExpression(node.getColumn()), (String)node.getValue().get(0)));
            }
            case IS_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNullPredicate(QueryContextConverterUtils.getExpression(node.getColumn())));
            }
            case IS_NOT_NULL: {
                return new FilterContext(FilterContext.Type.PREDICATE, null, new IsNotNullPredicate(QueryContextConverterUtils.getExpression(node.getColumn())));
            }
        }
        throw new IllegalStateException();
    }
}

