/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.GroupBy;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.Selection;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.FunctionContext;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;

public class BrokerRequestToQueryContextConverter {
    private BrokerRequestToQueryContextConverter() {
    }

    public static QueryContext convert(BrokerRequest brokerRequest) {
        Expression havingExpression;
        HashSet<ExpressionContext> expressionSet;
        int limit;
        ArrayList<ExpressionContext> selectExpressions;
        Map<ExpressionContext, String> aliasMap;
        String tableName = brokerRequest.getQuerySource().getTableName();
        PinotQuery pinotQuery = brokerRequest.getPinotQuery();
        ArrayList<ExpressionContext> groupByExpressions = null;
        int offset = 0;
        if (pinotQuery != null) {
            aliasMap = new HashMap();
            List selectList = pinotQuery.getSelectList();
            selectExpressions = new ArrayList<ExpressionContext>(selectList.size());
            for (Object thriftExpression : selectList) {
                Object expression;
                if (thriftExpression.getType() == ExpressionType.FUNCTION && thriftExpression.getFunctionCall().getOperator().equalsIgnoreCase("AS")) {
                    List operands = thriftExpression.getFunctionCall().getOperands();
                    expression = QueryContextConverterUtils.getExpression((Expression)operands.get(0));
                    aliasMap.put((ExpressionContext)expression, ((Expression)operands.get(1)).getIdentifier().getName());
                } else {
                    expression = QueryContextConverterUtils.getExpression((Expression)thriftExpression);
                }
                selectExpressions.add((ExpressionContext)expression);
            }
            List groupByList = pinotQuery.getGroupByList();
            if (CollectionUtils.isNotEmpty((Collection)groupByList)) {
                groupByExpressions = new ArrayList<ExpressionContext>(groupByList.size());
                for (Expression thriftExpression : groupByList) {
                    groupByExpressions.add(QueryContextConverterUtils.getExpression(thriftExpression));
                }
            }
            limit = pinotQuery.getLimit();
            offset = pinotQuery.getOffset();
        } else {
            aliasMap = Collections.emptyMap();
            Selection selections = brokerRequest.getSelections();
            if (selections != null) {
                List selectionColumns = selections.getSelectionColumns();
                selectExpressions = new ArrayList(selectionColumns.size());
                for (Object expression : selectionColumns) {
                    selectExpressions.add(QueryContextConverterUtils.getExpression((String)expression));
                }
                groupByExpressions = null;
                limit = brokerRequest.getLimit();
                offset = selections.getOffset();
                if (limit == 0) {
                    limit = selections.getSize();
                }
            } else {
                Object functionName;
                List aggregationsInfo = brokerRequest.getAggregationsInfo();
                selectExpressions = new ArrayList(aggregationsInfo.size());
                for (AggregationInfo aggregationInfo : aggregationsInfo) {
                    functionName = StringUtils.remove((String)aggregationInfo.getAggregationType(), (char)'_');
                    List stringExpressions = aggregationInfo.getExpressions();
                    int numArguments = stringExpressions.size();
                    ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(numArguments);
                    if (((String)functionName).equalsIgnoreCase(AggregationFunctionType.DISTINCT.getName())) {
                        for (String expression : stringExpressions) {
                            arguments.add(QueryContextConverterUtils.getExpression(expression));
                        }
                    } else {
                        arguments.add(QueryContextConverterUtils.getExpression((String)stringExpressions.get(0)));
                        for (int i = 1; i < numArguments; ++i) {
                            arguments.add(ExpressionContext.forLiteral((String)stringExpressions.get(i)));
                        }
                    }
                    FunctionContext function = new FunctionContext(FunctionContext.Type.AGGREGATION, (String)functionName, arguments);
                    selectExpressions.add(ExpressionContext.forFunction(function));
                }
                GroupBy groupBy = brokerRequest.getGroupBy();
                if (groupBy != null) {
                    Iterator stringExpressions = groupBy.getExpressions();
                    groupByExpressions = new ArrayList(stringExpressions.size());
                    functionName = stringExpressions.iterator();
                    while (functionName.hasNext()) {
                        String stringExpression = (String)functionName.next();
                        groupByExpressions.add(QueryContextConverterUtils.getExpression(stringExpression));
                    }
                    limit = (int)groupBy.getTopN();
                } else {
                    limit = brokerRequest.getLimit();
                }
            }
        }
        ArrayList<OrderByExpressionContext> orderByExpressions = null;
        if (pinotQuery != null) {
            List orderByList = pinotQuery.getOrderByList();
            if (CollectionUtils.isNotEmpty((Collection)orderByList)) {
                orderByExpressions = new ArrayList<OrderByExpressionContext>(orderByList.size());
                expressionSet = new HashSet<ExpressionContext>();
                for (Expression orderBy : orderByList) {
                    Function thriftFunction = orderBy.getFunctionCall();
                    ExpressionContext expression = QueryContextConverterUtils.getExpression((Expression)thriftFunction.getOperands().get(0));
                    if (!expressionSet.add(expression)) continue;
                    boolean isAsc = thriftFunction.getOperator().equalsIgnoreCase("ASC");
                    orderByExpressions.add(new OrderByExpressionContext(expression, isAsc));
                }
            }
        } else {
            List orderBy = brokerRequest.getOrderBy();
            if (CollectionUtils.isNotEmpty((Collection)orderBy)) {
                orderByExpressions = new ArrayList(orderBy.size());
                expressionSet = new HashSet();
                for (SelectionSort selectionSort : orderBy) {
                    ExpressionContext expression = QueryContextConverterUtils.getExpression(selectionSort.getColumn());
                    if (!expressionSet.add(expression)) continue;
                    orderByExpressions.add(new OrderByExpressionContext(expression, selectionSort.isIsAsc()));
                }
            }
        }
        FilterContext filter = null;
        FilterQueryTree root = RequestUtils.generateFilterQueryTree((BrokerRequest)brokerRequest);
        if (root != null) {
            filter = QueryContextConverterUtils.getFilter(root);
        }
        FilterContext havingFilter = null;
        if (pinotQuery != null && (havingExpression = pinotQuery.getHavingExpression()) != null) {
            havingFilter = QueryContextConverterUtils.getFilter(havingExpression);
        }
        return new QueryContext.Builder().setTableName(tableName).setSelectExpressions(selectExpressions).setAliasMap(aliasMap).setFilter(filter).setGroupByExpressions(groupByExpressions).setOrderByExpressions(orderByExpressions).setHavingFilter(havingFilter).setLimit(limit).setOffset(offset).setQueryOptions(brokerRequest.getQueryOptions()).setDebugOptions(brokerRequest.getDebugOptions()).setBrokerRequest(brokerRequest).build();
    }
}

