/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.AggregationResult;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.GroupByResult;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.SimpleIndexedTable;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByTrimmingService;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.HavingFilterHandler;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.core.util.trace.TraceRunnable;

public class GroupByDataTableReducer
implements DataTableReducer {
    private static final int MIN_DATA_TABLES_FOR_CONCURRENT_REDUCE = 2;
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final int _numAggregationFunctions;
    private final List<ExpressionContext> _groupByExpressions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final boolean _preserveType;
    private final boolean _groupByModeSql;
    private final boolean _responseFormatSql;
    private final boolean _sqlQuery;

    GroupByDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._numAggregationFunctions = this._aggregationFunctions.length;
        this._groupByExpressions = queryContext.getGroupByExpressions();
        assert (this._groupByExpressions != null);
        this._numGroupByExpressions = this._groupByExpressions.size();
        this._numColumns = this._numAggregationFunctions + this._numGroupByExpressions;
        QueryOptions queryOptions = new QueryOptions(queryContext.getQueryOptions());
        this._preserveType = queryOptions.isPreserveType();
        this._groupByModeSql = queryOptions.isGroupByModeSQL();
        this._responseFormatSql = queryOptions.isResponseFormatSQL();
        this._sqlQuery = queryContext.getBrokerRequest().getPinotQuery() != null;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        assert (dataSchema != null);
        int resultSize = 0;
        Collection<DataTable> dataTables = dataTableMap.values();
        if (this._groupByModeSql) {
            if (this._responseFormatSql) {
                try {
                    this.setSQLGroupByInResultTable(brokerResponseNative, dataSchema, dataTables, reducerContext);
                }
                catch (TimeoutException e) {
                    brokerResponseNative.getProcessingExceptions().add(new QueryProcessingException(400, e.getMessage()));
                }
                resultSize = brokerResponseNative.getResultTable().getRows().size();
            } else {
                try {
                    this.setSQLGroupByInAggregationResults(brokerResponseNative, dataSchema, dataTables, reducerContext);
                }
                catch (TimeoutException e) {
                    brokerResponseNative.getProcessingExceptions().add(new QueryProcessingException(400, e.getMessage()));
                }
                if (!brokerResponseNative.getAggregationResults().isEmpty()) {
                    resultSize = ((AggregationResult)brokerResponseNative.getAggregationResults().get(0)).getGroupByResult().size();
                }
            }
        } else {
            this.setGroupByResults(brokerResponseNative, dataTables);
            if (this._responseFormatSql) {
                resultSize = brokerResponseNative.getResultTable().getRows().size();
            } else if (!brokerResponseNative.getAggregationResults().isEmpty()) {
                resultSize = ((AggregationResult)brokerResponseNative.getAggregationResults().get(0)).getGroupByResult().size();
            }
        }
        if (brokerMetrics != null && resultSize > 0) {
            brokerMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)BrokerMeter.GROUP_BY_SIZE, (long)resultSize);
        }
    }

    private void setSQLGroupByInResultTable(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext) throws TimeoutException {
        IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
        Iterator<Record> sortedIterator = indexedTable.iterator();
        DataSchema prePostAggregationDataSchema = this.getPrePostAggregationDataSchema(dataSchema);
        int limit = this._queryContext.getLimit();
        ArrayList<Object[]> rows = new ArrayList<Object[]>(limit);
        if (this._sqlQuery) {
            PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, prePostAggregationDataSchema);
            DataSchema resultTableSchema = postAggregationHandler.getResultDataSchema();
            FilterContext havingFilter = this._queryContext.getHavingFilter();
            if (havingFilter != null) {
                HavingFilterHandler havingFilterHandler = new HavingFilterHandler(havingFilter, postAggregationHandler);
                while (rows.size() < limit && sortedIterator.hasNext()) {
                    Object[] row = sortedIterator.next().getValues();
                    this.extractFinalAggregationResults(row);
                    if (!havingFilterHandler.isMatch(row)) continue;
                    rows.add(row);
                }
            } else {
                for (int i = 0; i < limit && sortedIterator.hasNext(); ++i) {
                    Object[] row = sortedIterator.next().getValues();
                    this.extractFinalAggregationResults(row);
                    rows.add(row);
                }
            }
            rows.replaceAll(postAggregationHandler::getResult);
            brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, rows));
        } else {
            for (int i = 0; i < limit && sortedIterator.hasNext(); ++i) {
                Object[] row = sortedIterator.next().getValues();
                this.extractFinalAggregationResults(row);
                rows.add(row);
            }
            brokerResponseNative.setResultTable(new ResultTable(prePostAggregationDataSchema, rows));
        }
    }

    private void extractFinalAggregationResults(Object[] row) {
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            int valueIndex = i + this._numGroupByExpressions;
            row[valueIndex] = AggregationFunctionUtils.getSerializableValue(this._aggregationFunctions[i].extractFinalResult(row[valueIndex]));
        }
    }

    private DataSchema getPrePostAggregationDataSchema(DataSchema dataSchema) {
        String[] columnNames = dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        System.arraycopy(dataSchema.getColumnDataTypes(), 0, columnDataTypes, 0, this._numGroupByExpressions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            columnDataTypes[i + this._numGroupByExpressions] = this._aggregationFunctions[i].getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    private IndexedTable getIndexedTable(DataSchema dataSchema, Collection<DataTable> dataTablesToReduce, DataTableReducerContext reducerContext) throws TimeoutException {
        int i;
        long start = System.currentTimeMillis();
        int numDataTables = dataTablesToReduce.size();
        int numReduceThreadsToUse = this.getNumReduceThreadsToUse(numDataTables, reducerContext.getMaxReduceThreadsPerQuery());
        int capacity = GroupByUtils.getTableCapacity(this._queryContext);
        final IndexedTable indexedTable = numReduceThreadsToUse > 1 ? new ConcurrentIndexedTable(dataSchema, this._queryContext, capacity) : new SimpleIndexedTable(dataSchema, this._queryContext, capacity);
        Future[] futures = new Future[numDataTables];
        final CountDownLatch countDownLatch = new CountDownLatch(numDataTables);
        ArrayList<DataTable> dataTables = new ArrayList<DataTable>(dataTablesToReduce);
        ArrayList reduceGroups = new ArrayList(numReduceThreadsToUse);
        for (i = 0; i < numReduceThreadsToUse; ++i) {
            reduceGroups.add(new ArrayList());
        }
        for (i = 0; i < numDataTables; ++i) {
            ((List)reduceGroups.get(i % numReduceThreadsToUse)).add(dataTables.get(i));
        }
        int cnt = 0;
        final DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        for (final List list : reduceGroups) {
            futures[cnt++] = reducerContext.getExecutorService().submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runJob() {
                    for (DataTable dataTable : list) {
                        int numRows = dataTable.getNumberOfRows();
                        try {
                            for (int rowId = 0; rowId < numRows; ++rowId) {
                                Object[] values = new Object[GroupByDataTableReducer.this._numColumns];
                                block14: for (int colId = 0; colId < GroupByDataTableReducer.this._numColumns; ++colId) {
                                    switch (columnDataTypes[colId]) {
                                        case INT: {
                                            values[colId] = dataTable.getInt(rowId, colId);
                                            continue block14;
                                        }
                                        case LONG: {
                                            values[colId] = dataTable.getLong(rowId, colId);
                                            continue block14;
                                        }
                                        case FLOAT: {
                                            values[colId] = Float.valueOf(dataTable.getFloat(rowId, colId));
                                            continue block14;
                                        }
                                        case DOUBLE: {
                                            values[colId] = dataTable.getDouble(rowId, colId);
                                            continue block14;
                                        }
                                        case STRING: {
                                            values[colId] = dataTable.getString(rowId, colId);
                                            continue block14;
                                        }
                                        case BYTES: {
                                            values[colId] = dataTable.getBytes(rowId, colId);
                                            continue block14;
                                        }
                                        case OBJECT: {
                                            values[colId] = dataTable.getObject(rowId, colId);
                                            continue block14;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                indexedTable.upsert(new Record(values));
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }
            });
        }
        try {
            long timeOutMs = reducerContext.getReduceTimeOutMs() - (System.currentTimeMillis() - start);
            countDownLatch.await(timeOutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            throw new TimeoutException("Timed out in broker reduce phase.");
        }
        indexedTable.finish(true);
        return indexedTable;
    }

    private int getNumReduceThreadsToUse(int numDataTables, int maxReduceThreadsPerQuery) {
        if (numDataTables < 2) {
            return Math.min(1, numDataTables);
        }
        return Math.min(maxReduceThreadsPerQuery, numDataTables);
    }

    private void setSQLGroupByInAggregationResults(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext) throws TimeoutException {
        int idx;
        ArrayList<String> groupByColumns = new ArrayList<String>(this._numGroupByExpressions);
        for (idx = 0; idx < this._numGroupByExpressions; ++idx) {
            groupByColumns.add(dataSchema.getColumnName(idx));
        }
        ArrayList<String> aggregationColumns = new ArrayList<String>(this._numAggregationFunctions);
        ArrayList groupByResults = new ArrayList(this._numAggregationFunctions);
        while (idx < this._numColumns) {
            aggregationColumns.add(dataSchema.getColumnName(idx));
            groupByResults.add(new ArrayList());
            ++idx;
        }
        if (!dataTables.isEmpty()) {
            IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
            int limit = this._queryContext.getLimit();
            Iterator<Record> sortedIterator = indexedTable.iterator();
            for (int numRows = 0; numRows < limit && sortedIterator.hasNext(); ++numRows) {
                int index;
                Record nextRecord = sortedIterator.next();
                Object[] values = nextRecord.getValues();
                ArrayList<String> group = new ArrayList<String>(this._numGroupByExpressions);
                for (index = 0; index < this._numGroupByExpressions; ++index) {
                    group.add(values[index].toString());
                }
                int aggNum = 0;
                while (index < this._numColumns) {
                    Object serializableValue = this.getSerializableValue(this._aggregationFunctions[aggNum].extractFinalResult(values[index]));
                    if (!this._preserveType) {
                        serializableValue = AggregationFunctionUtils.formatValue(serializableValue);
                    }
                    GroupByResult groupByResult = new GroupByResult();
                    groupByResult.setGroup(group);
                    groupByResult.setValue((Serializable)serializableValue);
                    ((List)groupByResults.get(aggNum)).add(groupByResult);
                    ++index;
                    ++aggNum;
                }
            }
        }
        ArrayList<AggregationResult> aggregationResults = new ArrayList<AggregationResult>(this._numAggregationFunctions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            AggregationResult aggregationResult = new AggregationResult((List)groupByResults.get(i), groupByColumns, (String)aggregationColumns.get(i));
            aggregationResults.add(aggregationResult);
        }
        brokerResponseNative.setAggregationResults(aggregationResults);
    }

    private Serializable getSerializableValue(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return value.toString();
    }

    private DataSchema getPQLResultTableSchema(AggregationFunction aggregationFunction) {
        String[] columnNames = new String[this._numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            columnNames[i] = this._groupByExpressions.get(i).toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.STRING;
        }
        columnNames[this._numGroupByExpressions] = aggregationFunction.getResultColumnName();
        columnDataTypes[this._numGroupByExpressions] = aggregationFunction.getFinalResultColumnType();
        return new DataSchema(columnNames, columnDataTypes);
    }

    private void setGroupByResults(BrokerResponseNative brokerResponseNative, Collection<DataTable> dataTables) {
        int i;
        String[] columnNames = new String[this._numAggregationFunctions];
        Map[] intermediateResultMaps = new Map[this._numAggregationFunctions];
        if (this._numGroupByExpressions == 1) {
            for (DataTable dataTable : dataTables) {
                for (i = 0; i < this._numAggregationFunctions; ++i) {
                    if (columnNames[i] == null) {
                        columnNames[i] = dataTable.getString(i, 0);
                        intermediateResultMaps[i] = (Map)dataTable.getObject(i, 1);
                        continue;
                    }
                    this.mergeResultMap(intermediateResultMaps[i], (Map)dataTable.getObject(i, 1), this._aggregationFunctions[i]);
                }
            }
        } else {
            for (DataTable dataTable : dataTables) {
                for (i = 0; i < this._numAggregationFunctions; ++i) {
                    if (columnNames[i] == null) {
                        columnNames[i] = dataTable.getString(i, 0);
                        intermediateResultMaps[i] = this.convertLegacyGroupKeyDelimiter((Map)dataTable.getObject(i, 1));
                        continue;
                    }
                    this.mergeResultMap(intermediateResultMaps[i], this.convertLegacyGroupKeyDelimiter((Map)dataTable.getObject(i, 1)), this._aggregationFunctions[i]);
                }
            }
        }
        Map[] finalResultMaps = new Map[this._numAggregationFunctions];
        for (int i2 = 0; i2 < this._numAggregationFunctions; ++i2) {
            Map intermediateResultMap = intermediateResultMaps[i2];
            HashMap finalResultMap = new HashMap();
            for (Object groupKey : intermediateResultMap.keySet()) {
                Object intermediateResult = intermediateResultMap.get(groupKey);
                finalResultMap.put((String)groupKey, this._aggregationFunctions[i2].extractFinalResult(intermediateResult));
            }
            finalResultMaps[i2] = finalResultMap;
        }
        AggregationGroupByTrimmingService aggregationGroupByTrimmingService = new AggregationGroupByTrimmingService(this._queryContext);
        List<GroupByResult>[] groupByResultLists = aggregationGroupByTrimmingService.trimFinalResults(finalResultMaps);
        if (this._responseFormatSql) {
            Object groupKey;
            assert (this._numAggregationFunctions == 1);
            List<GroupByResult> groupByResultList = groupByResultLists[0];
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            groupKey = groupByResultList.iterator();
            while (groupKey.hasNext()) {
                GroupByResult groupByResult = (GroupByResult)groupKey.next();
                Object[] row = new Object[this._numColumns];
                int i3 = 0;
                for (String column : groupByResult.getGroup()) {
                    row[i3++] = column;
                }
                row[i3] = groupByResult.getValue();
                rows.add(row);
            }
            DataSchema finalDataSchema = this.getPQLResultTableSchema(this._aggregationFunctions[0]);
            brokerResponseNative.setResultTable(new ResultTable(finalDataSchema, rows));
        } else {
            if (!this._preserveType) {
                for (List<GroupByResult> groupByResultList : groupByResultLists) {
                    Iterator iterator = groupByResultList.iterator();
                    while (iterator.hasNext()) {
                        GroupByResult groupByResult = (GroupByResult)iterator.next();
                        groupByResult.setValue((Serializable)((Object)AggregationFunctionUtils.formatValue(groupByResult.getValue())));
                    }
                }
            }
            ArrayList<String> groupByColumns = new ArrayList<String>(this._numGroupByExpressions);
            for (ExpressionContext groupByExpression : this._groupByExpressions) {
                groupByColumns.add(groupByExpression.toString());
            }
            ArrayList<AggregationResult> aggregationResults = new ArrayList<AggregationResult>(this._numAggregationFunctions);
            for (int i4 = 0; i4 < this._numAggregationFunctions; ++i4) {
                aggregationResults.add(new AggregationResult(groupByResultLists[i4], groupByColumns, columnNames[i4]));
            }
            brokerResponseNative.setAggregationResults(aggregationResults);
        }
    }

    private void mergeResultMap(Map<String, Object> mergedResultMap, Map<String, Object> ResultMapToMerge, AggregationFunction aggregationFunction) {
        for (Map.Entry<String, Object> entry : ResultMapToMerge.entrySet()) {
            String groupKey = entry.getKey();
            Object resultToMerge = entry.getValue();
            mergedResultMap.compute(groupKey, (k, v) -> {
                if (v == null) {
                    return resultToMerge;
                }
                return aggregationFunction.merge(v, resultToMerge);
            });
        }
    }

    private Map<String, Object> convertLegacyGroupKeyDelimiter(Map<String, Object> resultMap) {
        assert (this._numGroupByExpressions > 1);
        if (resultMap.isEmpty()) {
            return resultMap;
        }
        String sampleKey = resultMap.keySet().iterator().next();
        if (sampleKey.indexOf(0) != -1) {
            return resultMap;
        }
        HashMap<String, Object> convertedResultMap = new HashMap<String, Object>(HashUtil.getHashMapCapacity((int)resultMap.size()));
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            convertedResultMap.put(entry.getKey().replace('\t', '\u0000'), entry.getValue());
        }
        return convertedResultMap;
    }
}

