/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.BrokerTimer;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ResultReducerFactory;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerReduceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerReduceService.class);
    private static final String REDUCE_THREAD_NAME_FORMAT = "brw-%d";
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    private final ExecutorService _reduceExecutorService;
    private final int _maxReduceThreadsPerQuery;

    public BrokerReduceService(PinotConfiguration config) {
        this._maxReduceThreadsPerQuery = config.getProperty("pinot.broker.max.reduce.threads.per.query", CommonConstants.Broker.DEFAULT_MAX_REDUCE_THREADS_PER_QUERY);
        int numThreadsInExecutorService = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Initializing BrokerReduceService with {} threads, and {} max reduce threads.", (Object)numThreadsInExecutorService, (Object)this._maxReduceThreadsPerQuery);
        ThreadFactory reduceThreadFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat(REDUCE_THREAD_NAME_FORMAT).build();
        this._reduceExecutorService = Executors.newFixedThreadPool(numThreadsInExecutorService, reduceThreadFactory);
    }

    public BrokerResponseNative reduceOnDataTable(BrokerRequest brokerRequest, Map<ServerRoutingInstance, DataTable> dataTableMap, long reduceTimeOutMs, @Nullable BrokerMetrics brokerMetrics) {
        if (dataTableMap.size() == 0) {
            return BrokerResponseNative.empty();
        }
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        List processingExceptions = brokerResponseNative.getProcessingExceptions();
        long numDocsScanned = 0L;
        long numEntriesScannedInFilter = 0L;
        long numEntriesScannedPostFilter = 0L;
        long numSegmentsQueried = 0L;
        long numSegmentsProcessed = 0L;
        long numSegmentsMatched = 0L;
        long numConsumingSegmentsProcessed = 0L;
        long minConsumingFreshnessTimeMs = Long.MAX_VALUE;
        long numTotalDocs = 0L;
        boolean numGroupsLimitReached = false;
        DataSchema cachedDataSchema = null;
        Iterator<Map.Entry<ServerRoutingInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String numTotalDocsString;
            String minConsumingFreshnessTimeMsString;
            String numConsumingString;
            String numSegmentsMatchedString;
            String numSegmentsProcessedString;
            String numSegmentsQueriedString;
            String numEntriesScannedPostFilterString;
            String numEntriesScannedInFilterString;
            Map.Entry<ServerRoutingInstance, DataTable> entry = iterator.next();
            DataTable dataTable = entry.getValue();
            Map metadata = dataTable.getMetadata();
            if (brokerRequest.isEnableTrace()) {
                brokerResponseNative.getTraceInfo().put(entry.getKey().getHostname(), metadata.get("traceInfo"));
            }
            for (String key : metadata.keySet()) {
                if (!key.startsWith("Exception")) continue;
                processingExceptions.add(new QueryProcessingException(Integer.parseInt(key.substring(9)), (String)metadata.get(key)));
            }
            String numDocsScannedString = (String)metadata.get("numDocsScanned");
            if (numDocsScannedString != null) {
                numDocsScanned += Long.parseLong(numDocsScannedString);
            }
            if ((numEntriesScannedInFilterString = (String)metadata.get("numEntriesScannedInFilter")) != null) {
                numEntriesScannedInFilter += Long.parseLong(numEntriesScannedInFilterString);
            }
            if ((numEntriesScannedPostFilterString = (String)metadata.get("numEntriesScannedPostFilter")) != null) {
                numEntriesScannedPostFilter += Long.parseLong(numEntriesScannedPostFilterString);
            }
            if ((numSegmentsQueriedString = (String)metadata.get("numSegmentsQueried")) != null) {
                numSegmentsQueried += Long.parseLong(numSegmentsQueriedString);
            }
            if ((numSegmentsProcessedString = (String)metadata.get("numSegmentsProcessed")) != null) {
                numSegmentsProcessed += Long.parseLong(numSegmentsProcessedString);
            }
            if ((numSegmentsMatchedString = (String)metadata.get("numSegmentsMatched")) != null) {
                numSegmentsMatched += Long.parseLong(numSegmentsMatchedString);
            }
            if ((numConsumingString = (String)metadata.get("numConsumingSegmentsProcessed")) != null) {
                numConsumingSegmentsProcessed += Long.parseLong(numConsumingString);
            }
            if ((minConsumingFreshnessTimeMsString = (String)metadata.get("minConsumingFreshnessTimeMs")) != null) {
                minConsumingFreshnessTimeMs = Math.min(Long.parseLong(minConsumingFreshnessTimeMsString), minConsumingFreshnessTimeMs);
            }
            if ((numTotalDocsString = (String)metadata.get("totalDocs")) != null) {
                numTotalDocs += Long.parseLong(numTotalDocsString);
            }
            numGroupsLimitReached |= Boolean.parseBoolean((String)metadata.get("numGroupsLimitReached"));
            DataSchema dataSchema = dataTable.getDataSchema();
            if (dataSchema == null) {
                iterator.remove();
                continue;
            }
            if (dataTable.getNumberOfRows() == 0) {
                if (cachedDataSchema == null) {
                    cachedDataSchema = dataSchema;
                }
                iterator.remove();
                continue;
            }
            cachedDataSchema = dataSchema;
        }
        brokerResponseNative.setNumDocsScanned(numDocsScanned);
        brokerResponseNative.setNumEntriesScannedInFilter(numEntriesScannedInFilter);
        brokerResponseNative.setNumEntriesScannedPostFilter(numEntriesScannedPostFilter);
        brokerResponseNative.setNumSegmentsQueried(numSegmentsQueried);
        brokerResponseNative.setNumSegmentsProcessed(numSegmentsProcessed);
        brokerResponseNative.setNumSegmentsMatched(numSegmentsMatched);
        brokerResponseNative.setTotalDocs(numTotalDocs);
        brokerResponseNative.setNumGroupsLimitReached(numGroupsLimitReached);
        if (numConsumingSegmentsProcessed > 0L) {
            brokerResponseNative.setNumConsumingSegmentsQueried(numConsumingSegmentsProcessed);
            brokerResponseNative.setMinConsumingFreshnessTimeMs(minConsumingFreshnessTimeMs);
        }
        String tableName = brokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        if (brokerMetrics != null) {
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.DOCUMENTS_SCANNED, numDocsScanned);
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.ENTRIES_SCANNED_IN_FILTER, numEntriesScannedInFilter);
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.ENTRIES_SCANNED_POST_FILTER, numEntriesScannedPostFilter);
            if (numConsumingSegmentsProcessed > 0L && minConsumingFreshnessTimeMs > 0L) {
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.FRESHNESS_LAG_MS, System.currentTimeMillis() - minConsumingFreshnessTimeMs, TimeUnit.MILLISECONDS);
            }
        }
        if (cachedDataSchema == null) {
            return brokerResponseNative;
        }
        QueryContext queryContext = BrokerRequestToQueryContextConverter.convert(brokerRequest);
        DataTableReducer dataTableReducer = ResultReducerFactory.getResultReducer(queryContext);
        dataTableReducer.reduceAndSetResults(tableName, cachedDataSchema, dataTableMap, brokerResponseNative, new DataTableReducerContext(this._reduceExecutorService, this._maxReduceThreadsPerQuery, reduceTimeOutMs), brokerMetrics);
        BrokerReduceService.updateAlias(queryContext, brokerResponseNative);
        return brokerResponseNative;
    }

    private static void updateAlias(QueryContext queryContext, BrokerResponseNative brokerResponseNative) {
        List<ExpressionContext> selectExpressions;
        int numSelectExpressions;
        ResultTable resultTable = brokerResponseNative.getResultTable();
        if (resultTable == null) {
            return;
        }
        Map<ExpressionContext, String> aliasMap = queryContext.getAliasMap();
        if (aliasMap.isEmpty()) {
            return;
        }
        String[] columnNames = resultTable.getDataSchema().getColumnNames();
        if (columnNames.length != (numSelectExpressions = (selectExpressions = queryContext.getSelectExpressions()).size())) {
            return;
        }
        for (int i = 0; i < numSelectExpressions; ++i) {
            String alias = aliasMap.get(selectExpressions.get(i));
            if (alias == null) continue;
            columnNames[i] = alias;
        }
    }

    public void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

