/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.spi.env.PinotConfiguration;

public class SelectionQuerySegmentPruner
implements SegmentPruner {
    @Override
    public void init(PinotConfiguration config) {
    }

    @Override
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        if (segments.isEmpty()) {
            return segments;
        }
        if (QueryContextUtils.isAggregationQuery(query)) {
            return segments;
        }
        int limit = query.getLimit();
        if (limit == 0) {
            return Collections.singletonList(segments.get(0));
        }
        FilterContext filter = query.getFilter();
        if (filter != null) {
            return segments;
        }
        if (segments.get(0).getValidDocIndex() != null) {
            return segments;
        }
        if (query.getOrderByExpressions() == null) {
            return this.pruneSelectionOnly(segments, query);
        }
        return this.pruneSelectionOrderBy(segments, query);
    }

    private List<IndexSegment> pruneSelectionOnly(List<IndexSegment> segments, QueryContext query) {
        ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>(segments.size());
        int remainingDocs = query.getLimit();
        for (IndexSegment segment : segments) {
            if (remainingDocs <= 0) break;
            selectedSegments.add(segment);
            remainingDocs -= segment.getSegmentMetadata().getTotalDocs();
        }
        return selectedSegments;
    }

    private List<IndexSegment> pruneSelectionOrderBy(List<IndexSegment> segments, QueryContext query) {
        IndexSegment segment;
        List<OrderByExpressionContext> orderByExpressions = query.getOrderByExpressions();
        assert (orderByExpressions != null);
        int numOrderByExpressions = orderByExpressions.size();
        assert (numOrderByExpressions > 0);
        OrderByExpressionContext firstOrderByExpression = orderByExpressions.get(0);
        if (firstOrderByExpression.getExpression().getType() != ExpressionContext.Type.IDENTIFIER) {
            return segments;
        }
        String firstOrderByColumn = firstOrderByExpression.getExpression().getIdentifier();
        int numSegments = segments.size();
        ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>(numSegments);
        ArrayList<MinMaxValue> minMaxValues = new ArrayList<MinMaxValue>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            IndexSegment segment2 = segments.get(i);
            DataSourceMetadata dataSourceMetadata = segment2.getDataSource(firstOrderByColumn).getDataSourceMetadata();
            Comparable minValue = dataSourceMetadata.getMinValue();
            Comparable maxValue = dataSourceMetadata.getMaxValue();
            if (minValue == null || maxValue == null) {
                selectedSegments.add(segment2);
                continue;
            }
            minMaxValues.add(new MinMaxValue(i, minValue, maxValue));
        }
        if (minMaxValues.isEmpty()) {
            return segments;
        }
        int remainingDocs = query.getLimit() + query.getOffset();
        if (firstOrderByExpression.isAsc()) {
            try {
                minMaxValues.sort(Comparator.comparing(o -> o._maxValue));
            }
            catch (Exception e) {
                return segments;
            }
            Comparable maxValue = null;
            for (MinMaxValue minMaxValue : minMaxValues) {
                segment = segments.get(minMaxValue._index);
                if (remainingDocs > 0) {
                    selectedSegments.add(segment);
                    remainingDocs -= segment.getSegmentMetadata().getTotalDocs();
                    maxValue = minMaxValue._maxValue;
                    continue;
                }
                assert (maxValue != null);
                int result = minMaxValue._minValue.compareTo(maxValue);
                if (result >= 0 && (result != 0 || numOrderByExpressions == 1)) continue;
                selectedSegments.add(segment);
            }
        } else {
            try {
                minMaxValues.sort((o1, o2) -> o2._minValue.compareTo(o1._minValue));
            }
            catch (Exception e) {
                return segments;
            }
            Comparable minValue = null;
            for (MinMaxValue minMaxValue : minMaxValues) {
                segment = segments.get(minMaxValue._index);
                if (remainingDocs > 0) {
                    selectedSegments.add(segment);
                    remainingDocs -= segment.getSegmentMetadata().getTotalDocs();
                    minValue = minMaxValue._minValue;
                    continue;
                }
                assert (minValue != null);
                int result = minMaxValue._maxValue.compareTo(minValue);
                if (result <= 0 && (result != 0 || numOrderByExpressions == 1)) continue;
                selectedSegments.add(segment);
            }
        }
        return selectedSegments;
    }

    private static class MinMaxValue {
        final int _index;
        final Comparable _minValue;
        final Comparable _maxValue;

        private MinMaxValue(int index, Comparable minValue, Comparable maxValue) {
            this._index = index;
            this._minValue = minValue;
            this._maxValue = maxValue;
        }
    }
}

