/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.query.pruner.ColumnValueSegmentPruner;
import org.apache.pinot.core.query.pruner.DataSchemaSegmentPruner;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.pruner.SelectionQuerySegmentPruner;
import org.apache.pinot.core.query.pruner.ValidSegmentPruner;
import org.apache.pinot.spi.env.PinotConfiguration;

public class SegmentPrunerProvider {
    private static final Map<String, Class<? extends SegmentPruner>> PRUNER_MAP = new HashMap<String, Class<? extends SegmentPruner>>();

    private SegmentPrunerProvider() {
    }

    public static SegmentPruner getSegmentPruner(String prunerClassName, PinotConfiguration segmentPrunerConfig) {
        try {
            Class<? extends SegmentPruner> cls = PRUNER_MAP.get(prunerClassName.toLowerCase());
            if (cls != null) {
                SegmentPruner segmentPruner = cls.newInstance();
                segmentPruner.init(segmentPrunerConfig);
                return segmentPruner;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Not support SegmentPruner type with - " + prunerClassName, ex);
        }
        throw new UnsupportedOperationException("No SegmentPruner type with - " + prunerClassName);
    }

    static {
        PRUNER_MAP.put("columnvaluesegmentpruner", ColumnValueSegmentPruner.class);
        PRUNER_MAP.put("dataschemasegmentpruner", DataSchemaSegmentPruner.class);
        PRUNER_MAP.put("validsegmentpruner", ValidSegmentPruner.class);
        PRUNER_MAP.put("selectionquerysegmentpruner", SelectionQuerySegmentPruner.class);
    }
}

