/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.common.DataSourceMetadata;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.query.exception.BadQueryRequestException;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.predicate.EqPredicate;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.query.request.context.predicate.RangePredicate;
import org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.BytesUtils;

public class ColumnValueSegmentPruner
implements SegmentPruner {
    @Override
    public void init(PinotConfiguration config) {
    }

    @Override
    public boolean prune(IndexSegment segment, QueryContext query) {
        FilterContext filter = query.getFilter();
        if (filter == null) {
            return false;
        }
        HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
        return this.pruneSegment(segment, filter, dataSourceCache);
    }

    private boolean pruneSegment(IndexSegment segment, FilterContext filter, Map<String, DataSource> dataSourceCache) {
        switch (filter.getType()) {
            case AND: {
                for (FilterContext child : filter.getChildren()) {
                    if (!this.pruneSegment(segment, child, dataSourceCache)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    if (this.pruneSegment(segment, child, dataSourceCache)) continue;
                    return false;
                }
                return true;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
                    return false;
                }
                Predicate.Type predicateType = predicate.getType();
                if (predicateType == Predicate.Type.EQ) {
                    return this.pruneEqPredicate(segment, (EqPredicate)predicate, dataSourceCache);
                }
                if (predicateType == Predicate.Type.RANGE) {
                    return this.pruneRangePredicate(segment, (RangePredicate)predicate, dataSourceCache);
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private boolean pruneEqPredicate(IndexSegment segment, EqPredicate eqPredicate, Map<String, DataSource> dataSourceCache) {
        BloomFilterReader bloomFilter;
        String column = eqPredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, segment::getDataSource);
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        Comparable value = ColumnValueSegmentPruner.convertValue(eqPredicate.getValue(), dataSourceMetadata.getDataType());
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && value.compareTo(minValue) < 0) {
            return true;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        if (maxValue != null && value.compareTo(maxValue) > 0) {
            return true;
        }
        PartitionFunction partitionFunction = dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            Set<Integer> partitions = dataSourceMetadata.getPartitions();
            assert (partitions != null);
            if (!partitions.contains(partitionFunction.getPartition(value))) {
                return true;
            }
        }
        return (bloomFilter = dataSource.getBloomFilter()) != null && !bloomFilter.mightContain(value.toString());
    }

    private boolean pruneRangePredicate(IndexSegment segment, RangePredicate rangePredicate, Map<String, DataSource> dataSourceCache) {
        String column = rangePredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, segment::getDataSource);
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        FieldSpec.DataType dataType = dataSourceMetadata.getDataType();
        String lowerBound = rangePredicate.getLowerBound();
        Comparable lowerBoundValue = null;
        if (!lowerBound.equals("*")) {
            lowerBoundValue = ColumnValueSegmentPruner.convertValue(lowerBound, dataType);
        }
        boolean lowerInclusive = rangePredicate.isLowerInclusive();
        String upperBound = rangePredicate.getUpperBound();
        Comparable upperBoundValue = null;
        if (!upperBound.equals("*")) {
            upperBoundValue = ColumnValueSegmentPruner.convertValue(upperBound, dataType);
        }
        boolean upperInclusive = rangePredicate.isUpperInclusive();
        if (lowerBoundValue != null && upperBoundValue != null && (lowerInclusive && upperInclusive ? lowerBoundValue.compareTo(upperBoundValue) > 0 : lowerBoundValue.compareTo(upperBoundValue) >= 0)) {
            return true;
        }
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && upperBoundValue != null && (upperInclusive ? upperBoundValue.compareTo(minValue) < 0 : upperBoundValue.compareTo(minValue) <= 0)) {
            return true;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue != null && lowerBoundValue != null && (lowerInclusive ? lowerBoundValue.compareTo(maxValue) > 0 : lowerBoundValue.compareTo(maxValue) >= 0);
    }

    private static Comparable convertValue(String stringValue, FieldSpec.DataType dataType) {
        try {
            switch (dataType) {
                case INT: {
                    return Integer.valueOf(stringValue);
                }
                case LONG: {
                    return Long.valueOf(stringValue);
                }
                case FLOAT: {
                    return Float.valueOf(stringValue);
                }
                case DOUBLE: {
                    return Double.valueOf(stringValue);
                }
                case STRING: {
                    return stringValue;
                }
                case BYTES: {
                    return BytesUtils.toByteArray((String)stringValue);
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            throw new BadQueryRequestException(String.format("Cannot convert value: '%s' to type: %s", stringValue, dataType), e);
        }
    }
}

