/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.spi.data.Schema;

public class MergeEqInFilterOptimizer
implements FilterOptimizer {
    @Override
    public FilterQueryTree optimize(FilterQueryTree filterQueryTree, @Nullable Schema schema) {
        FilterOperator operator = filterQueryTree.getOperator();
        if (operator == FilterOperator.OR) {
            List children = filterQueryTree.getChildren();
            HashMap valuesMap = new HashMap();
            ArrayList<FilterQueryTree> newChildren = new ArrayList<FilterQueryTree>();
            boolean recreateFilter = false;
            for (FilterQueryTree filterQueryTree2 : children) {
                String column;
                FilterOperator childOperator = filterQueryTree2.getOperator();
                assert (childOperator != FilterOperator.OR);
                if (childOperator == FilterOperator.AND) {
                    filterQueryTree2.getChildren().replaceAll(c -> this.optimize((FilterQueryTree)c, schema));
                    newChildren.add(filterQueryTree2);
                    continue;
                }
                if (childOperator == FilterOperator.EQUALITY) {
                    column = filterQueryTree2.getColumn();
                    String value = (String)filterQueryTree2.getValue().get(0);
                    HashSet<String> values = (HashSet<String>)valuesMap.get(column);
                    if (values == null) {
                        values = new HashSet<String>();
                        values.add(value);
                        valuesMap.put(column, values);
                        continue;
                    }
                    values.add(value);
                    recreateFilter = true;
                    continue;
                }
                if (childOperator == FilterOperator.IN) {
                    Set values;
                    column = filterQueryTree2.getColumn();
                    List inPredicateValuesList = filterQueryTree2.getValue();
                    HashSet inPredicateValuesSet = new HashSet(inPredicateValuesList);
                    int numUniqueValues = inPredicateValuesSet.size();
                    if (numUniqueValues == 1 || numUniqueValues != inPredicateValuesList.size()) {
                        recreateFilter = true;
                    }
                    if ((values = (Set)valuesMap.get(column)) == null) {
                        valuesMap.put(column, inPredicateValuesSet);
                        continue;
                    }
                    values.addAll(inPredicateValuesSet);
                    recreateFilter = true;
                    continue;
                }
                newChildren.add(filterQueryTree2);
            }
            if (recreateFilter) {
                if (newChildren.isEmpty() && valuesMap.size() == 1) {
                    Map.Entry entry = valuesMap.entrySet().iterator().next();
                    return MergeEqInFilterOptimizer.getFilterQueryTree((String)entry.getKey(), (Set)entry.getValue());
                }
                for (Map.Entry entry : valuesMap.entrySet()) {
                    newChildren.add(MergeEqInFilterOptimizer.getFilterQueryTree((String)entry.getKey(), (Set)entry.getValue()));
                }
                return new FilterQueryTree(null, null, FilterOperator.OR, newChildren);
            }
            return filterQueryTree;
        }
        if (operator == FilterOperator.AND) {
            filterQueryTree.getChildren().replaceAll(c -> this.optimize((FilterQueryTree)c, schema));
            return filterQueryTree;
        }
        if (operator == FilterOperator.IN) {
            String column = filterQueryTree.getColumn();
            List valuesList = filterQueryTree.getValue();
            HashSet<String> values = new HashSet<String>(valuesList);
            int numUniqueValues = values.size();
            if (numUniqueValues == 1 || numUniqueValues != valuesList.size()) {
                return MergeEqInFilterOptimizer.getFilterQueryTree(column, values);
            }
            return filterQueryTree;
        }
        return filterQueryTree;
    }

    private static FilterQueryTree getFilterQueryTree(String column, Set<String> values) {
        return new FilterQueryTree(column, new ArrayList<String>(values), values.size() == 1 ? FilterOperator.EQUALITY : FilterOperator.IN, null);
    }

    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        Function function = filterExpression.getFunctionCall();
        String operator = function.getOperator();
        if (operator.equals(FilterKind.OR.name())) {
            List children = function.getOperands();
            HashMap valuesMap = new HashMap();
            ArrayList<Expression> newChildren = new ArrayList<Expression>();
            boolean recreateFilter = false;
            for (Expression child : children) {
                Expression lhs;
                List operands;
                Function childFunction = child.getFunctionCall();
                String childOperator = childFunction.getOperator();
                assert (!childOperator.equals(FilterKind.OR.name()));
                if (childOperator.equals(FilterKind.AND.name())) {
                    childFunction.getOperands().replaceAll(o -> this.optimize((Expression)o, schema));
                    newChildren.add(child);
                    continue;
                }
                if (childOperator.equals(FilterKind.EQUALS.name())) {
                    operands = childFunction.getOperands();
                    lhs = (Expression)operands.get(0);
                    Expression value = (Expression)operands.get(1);
                    HashSet<Expression> values = (HashSet<Expression>)valuesMap.get(lhs);
                    if (values == null) {
                        values = new HashSet<Expression>();
                        values.add(value);
                        valuesMap.put(lhs, values);
                        continue;
                    }
                    values.add(value);
                    recreateFilter = true;
                    continue;
                }
                if (childOperator.equals(FilterKind.IN.name())) {
                    Set values;
                    operands = childFunction.getOperands();
                    lhs = (Expression)operands.get(0);
                    HashSet inPredicateValuesSet = new HashSet();
                    int numOperands = operands.size();
                    for (int i = 1; i < numOperands; ++i) {
                        inPredicateValuesSet.add(operands.get(i));
                    }
                    int numUniqueValues = inPredicateValuesSet.size();
                    if (numUniqueValues == 1 || numUniqueValues != numOperands - 1) {
                        recreateFilter = true;
                    }
                    if ((values = (Set)valuesMap.get(lhs)) == null) {
                        valuesMap.put(lhs, inPredicateValuesSet);
                        continue;
                    }
                    values.addAll(inPredicateValuesSet);
                    recreateFilter = true;
                    continue;
                }
                newChildren.add(child);
            }
            if (recreateFilter) {
                if (newChildren.isEmpty() && valuesMap.size() == 1) {
                    Map.Entry entry = valuesMap.entrySet().iterator().next();
                    return MergeEqInFilterOptimizer.getFilterExpression((Expression)entry.getKey(), (Set)entry.getValue());
                }
                for (Map.Entry entry : valuesMap.entrySet()) {
                    newChildren.add(MergeEqInFilterOptimizer.getFilterExpression((Expression)entry.getKey(), (Set)entry.getValue()));
                }
                function.setOperands(newChildren);
                return filterExpression;
            }
            return filterExpression;
        }
        if (operator.equals(FilterKind.AND.name())) {
            function.getOperands().replaceAll(c -> this.optimize((Expression)c, schema));
            return filterExpression;
        }
        if (operator.equals(FilterKind.IN.name())) {
            List operands = function.getOperands();
            Expression lhs = (Expression)operands.get(0);
            HashSet<Expression> values = new HashSet<Expression>();
            int numOperands = operands.size();
            for (int i = 1; i < numOperands; ++i) {
                values.add((Expression)operands.get(i));
            }
            int numUniqueValues = values.size();
            if (numUniqueValues == 1 || numUniqueValues != numOperands - 1) {
                return MergeEqInFilterOptimizer.getFilterExpression(lhs, values);
            }
            return filterExpression;
        }
        return filterExpression;
    }

    private static Expression getFilterExpression(Expression lhs, Set<Expression> values) {
        int numValues = values.size();
        if (numValues == 1) {
            Expression eqFilter = RequestUtils.getFunctionExpression((String)FilterKind.EQUALS.name());
            eqFilter.getFunctionCall().setOperands(Arrays.asList(lhs, values.iterator().next()));
            return eqFilter;
        }
        Expression inFilter = RequestUtils.getFunctionExpression((String)FilterKind.IN.name());
        ArrayList<Expression> operands = new ArrayList<Expression>(numValues + 1);
        operands.add(lhs);
        operands.addAll(values);
        inFilter.getFunctionCall().setOperands(operands);
        return inFilter;
    }
}

