/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.spi.env.PinotConfiguration;

public class SegmentPrunerConfig {
    private static final String SEGMENT_PRUNER_NAMES_KEY = "class";
    private final int _numSegmentPruners;
    private final List<String> _segmentPrunerNames;
    private final List<PinotConfiguration> _segmentPrunerConfigs;

    public SegmentPrunerConfig(PinotConfiguration segmentPrunerConfig) {
        List segmentPrunerNames = segmentPrunerConfig.getProperty(SEGMENT_PRUNER_NAMES_KEY, Arrays.asList(new String[0]));
        this._numSegmentPruners = segmentPrunerNames.size();
        this._segmentPrunerNames = new ArrayList<String>(this._numSegmentPruners);
        this._segmentPrunerConfigs = new ArrayList<PinotConfiguration>(this._numSegmentPruners);
        for (String segmentPrunerName : segmentPrunerNames) {
            this._segmentPrunerNames.add(segmentPrunerName);
            this._segmentPrunerConfigs.add(segmentPrunerConfig.subset(segmentPrunerName));
        }
    }

    public int numSegmentPruners() {
        return this._numSegmentPruners;
    }

    public String getSegmentPrunerName(int index) {
        return this._segmentPrunerNames.get(index);
    }

    public PinotConfiguration getSegmentPrunerConfig(int index) {
        return this._segmentPrunerConfigs.get(index);
    }
}

