/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;

public class DoubleGroupByResultHolder
implements GroupByResultHolder {
    private final int _maxCapacity;
    private final double _defaultValue;
    private int _resultHolderCapacity;
    private double[] _resultArray;

    public DoubleGroupByResultHolder(int initialCapacity, int maxCapacity, double defaultValue) {
        this._maxCapacity = maxCapacity;
        this._defaultValue = defaultValue;
        this._resultHolderCapacity = initialCapacity;
        this._resultArray = new double[initialCapacity];
        if (defaultValue != 0.0) {
            Arrays.fill(this._resultArray, defaultValue);
        }
    }

    @Override
    public void ensureCapacity(int capacity) {
        Preconditions.checkArgument((capacity <= this._maxCapacity ? 1 : 0) != 0);
        if (capacity > this._resultHolderCapacity) {
            int copyLength = this._resultHolderCapacity;
            this._resultHolderCapacity = Math.max(this._resultHolderCapacity * 2, capacity);
            this._resultHolderCapacity = Math.min(this._resultHolderCapacity, this._maxCapacity);
            double[] current = this._resultArray;
            this._resultArray = new double[this._resultHolderCapacity];
            System.arraycopy(current, 0, this._resultArray, 0, copyLength);
            if (this._defaultValue != 0.0) {
                Arrays.fill(this._resultArray, copyLength, this._resultHolderCapacity, this._defaultValue);
            }
        }
    }

    @Override
    public double getDoubleResult(int groupKey) {
        if (groupKey == -1) {
            return this._defaultValue;
        }
        return this._resultArray[groupKey];
    }

    @Override
    public <T> T getResult(int groupKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValueForKey(int groupKey, double newValue) {
        if (groupKey != -1) {
            this._resultArray[groupKey] = newValue;
        }
    }

    @Override
    public void setValueForKey(int groupKey, Object newValue) {
        throw new UnsupportedOperationException();
    }
}

