/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.segment.index.readers.Dictionary;

public class DictionaryBasedGroupKeyGenerator
implements GroupKeyGenerator {
    private static final int INITIAL_MAP_SIZE = 256;
    private static final int MAX_CACHING_MAP_SIZE = 0x100000;
    private final ExpressionContext[] _groupByExpressions;
    private final int _numGroupByExpressions;
    private final int[] _cardinalities;
    private final boolean[] _isSingleValueColumn;
    private final Dictionary[] _dictionaries;
    private final int[][] _singleValueDictIds;
    private final int[][][] _multiValueDictIds;
    private final int _globalGroupIdUpperBound;
    private final RawKeyHolder _rawKeyHolder;

    public DictionaryBasedGroupKeyGenerator(TransformOperator transformOperator, ExpressionContext[] groupByExpressions, int numGroupsLimit, int arrayBasedThreshold, Map mapBasedRawKeyHolders) {
        assert (numGroupsLimit >= arrayBasedThreshold);
        this._groupByExpressions = groupByExpressions;
        this._numGroupByExpressions = groupByExpressions.length;
        this._cardinalities = new int[this._numGroupByExpressions];
        this._isSingleValueColumn = new boolean[this._numGroupByExpressions];
        this._dictionaries = new Dictionary[this._numGroupByExpressions];
        this._singleValueDictIds = new int[this._numGroupByExpressions][];
        this._multiValueDictIds = new int[this._numGroupByExpressions][][];
        long cardinalityProduct = 1L;
        boolean longOverflow = false;
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            int cardinality;
            ExpressionContext groupByExpression = groupByExpressions[i];
            this._dictionaries[i] = transformOperator.getDictionary(groupByExpression);
            this._cardinalities[i] = cardinality = this._dictionaries[i].length();
            if (!longOverflow) {
                if (cardinalityProduct > Long.MAX_VALUE / (long)cardinality) {
                    longOverflow = true;
                } else {
                    cardinalityProduct *= (long)cardinality;
                }
            }
            this._isSingleValueColumn[i] = transformOperator.getResultMetadata(groupByExpression).isSingleValue();
        }
        if (longOverflow) {
            this._globalGroupIdUpperBound = numGroupsLimit;
            Object mapInternal = mapBasedRawKeyHolders.computeIfAbsent(ArrayMapBasedHolder.class.getName(), o -> new ArrayMapBasedHolder(256).getInternal());
            this._rawKeyHolder = new ArrayMapBasedHolder(mapInternal);
            if (((Object2IntOpenHashMap)mapInternal).size() > 0x100000) {
                mapBasedRawKeyHolders.put(ArrayMapBasedHolder.class.getName(), new ArrayMapBasedHolder(256).getInternal());
            }
        } else if (cardinalityProduct > Integer.MAX_VALUE) {
            this._globalGroupIdUpperBound = numGroupsLimit;
            Object mapInternal = mapBasedRawKeyHolders.computeIfAbsent(LongMapBasedHolder.class.getName(), o -> new LongMapBasedHolder(256).getInternal());
            this._rawKeyHolder = new LongMapBasedHolder(mapInternal);
            if (((Long2IntOpenHashMap)mapInternal).size() > 0x100000) {
                mapBasedRawKeyHolders.put(ArrayMapBasedHolder.class.getName(), new ArrayMapBasedHolder(256).getInternal());
            }
        } else {
            this._globalGroupIdUpperBound = Math.min((int)cardinalityProduct, numGroupsLimit);
            if (cardinalityProduct > (long)arrayBasedThreshold) {
                Object mapInternal = mapBasedRawKeyHolders.computeIfAbsent(IntMapBasedHolder.class.getName(), o -> new IntMapBasedHolder(256).getInternal());
                this._rawKeyHolder = new IntMapBasedHolder(mapInternal);
                if (((Int2IntOpenHashMap)mapInternal).size() > 0x100000) {
                    mapBasedRawKeyHolders.put(ArrayMapBasedHolder.class.getName(), new ArrayMapBasedHolder(256).getInternal());
                }
            } else {
                this._rawKeyHolder = new ArrayBasedHolder();
            }
        }
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[] groupKeys) {
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._groupByExpressions[i]);
            this._singleValueDictIds[i] = blockValueSet.getDictionaryIdsSV();
        }
        this._rawKeyHolder.processSingleValue(transformBlock.getNumDocs(), groupKeys);
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[][] groupKeys) {
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._groupByExpressions[i]);
            if (this._isSingleValueColumn[i]) {
                this._singleValueDictIds[i] = blockValueSet.getDictionaryIdsSV();
                continue;
            }
            this._multiValueDictIds[i] = blockValueSet.getDictionaryIdsMV();
        }
        this._rawKeyHolder.processMultiValue(transformBlock.getNumDocs(), groupKeys);
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._rawKeyHolder.getGroupIdUpperBound();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getUniqueGroupKeys() {
        return this._rawKeyHolder.iterator();
    }

    private int[] getIntRawKeys(int index) {
        int[] rawKeys = null;
        if (this._numGroupByExpressions == 1) {
            rawKeys = this._multiValueDictIds[0][index];
        } else {
            int rawKey = 0;
            for (int i = this._numGroupByExpressions - 1; i >= 0; --i) {
                int j;
                int cardinality = this._cardinalities[i];
                if (this._isSingleValueColumn[i]) {
                    int dictId = this._singleValueDictIds[i][index];
                    if (rawKeys == null) {
                        rawKey = rawKey * cardinality + dictId;
                        continue;
                    }
                    int length = rawKeys.length;
                    for (j = 0; j < length; ++j) {
                        rawKeys[j] = rawKeys[j] * cardinality + dictId;
                    }
                    continue;
                }
                int[] multiValueDictIds = this._multiValueDictIds[i][index];
                int numValues = multiValueDictIds.length;
                if (numValues == 1) {
                    int dictId = multiValueDictIds[0];
                    if (rawKeys == null) {
                        rawKey = rawKey * cardinality + dictId;
                        continue;
                    }
                    int length = rawKeys.length;
                    for (int j2 = 0; j2 < length; ++j2) {
                        rawKeys[j2] = rawKeys[j2] * cardinality + dictId;
                    }
                    continue;
                }
                if (rawKeys == null) {
                    rawKeys = new int[numValues];
                    for (j = 0; j < numValues; ++j) {
                        int dictId = multiValueDictIds[j];
                        rawKeys[j] = rawKey * cardinality + dictId;
                    }
                    continue;
                }
                int currentLength = rawKeys.length;
                int newLength = currentLength * numValues;
                int[] newRawKeys = new int[newLength];
                for (int j3 = 0; j3 < numValues; ++j3) {
                    int startOffset = j3 * currentLength;
                    System.arraycopy(rawKeys, 0, newRawKeys, startOffset, currentLength);
                    int dictId = multiValueDictIds[j3];
                    int endOffset = startOffset + currentLength;
                    for (int k = startOffset; k < endOffset; ++k) {
                        newRawKeys[k] = newRawKeys[k] * cardinality + dictId;
                    }
                }
                rawKeys = newRawKeys;
            }
            if (rawKeys == null) {
                rawKeys = new int[]{rawKey};
            }
        }
        return rawKeys;
    }

    private String getGroupKey(int rawKey) {
        if (this._numGroupByExpressions == 1) {
            return this._dictionaries[0].getStringValue(rawKey);
        }
        int cardinality = this._cardinalities[0];
        StringBuilder groupKeyBuilder = new StringBuilder(this._dictionaries[0].getStringValue(rawKey % cardinality));
        rawKey /= cardinality;
        for (int i = 1; i < this._numGroupByExpressions; ++i) {
            groupKeyBuilder.append('\u0000');
            cardinality = this._cardinalities[i];
            groupKeyBuilder.append(this._dictionaries[i].getStringValue(rawKey % cardinality));
            rawKey /= cardinality;
        }
        return groupKeyBuilder.toString();
    }

    private long[] getLongRawKeys(int index) {
        long[] rawKeys = null;
        long rawKey = 0L;
        for (int i = this._numGroupByExpressions - 1; i >= 0; --i) {
            int j;
            int cardinality = this._cardinalities[i];
            if (this._isSingleValueColumn[i]) {
                int dictId = this._singleValueDictIds[i][index];
                if (rawKeys == null) {
                    rawKey = rawKey * (long)cardinality + (long)dictId;
                    continue;
                }
                int length = rawKeys.length;
                for (j = 0; j < length; ++j) {
                    rawKeys[j] = rawKeys[j] * (long)cardinality + (long)dictId;
                }
                continue;
            }
            int[] multiValueDictIds = this._multiValueDictIds[i][index];
            int numValues = multiValueDictIds.length;
            if (numValues == 1) {
                int dictId = multiValueDictIds[0];
                if (rawKeys == null) {
                    rawKey = rawKey * (long)cardinality + (long)dictId;
                    continue;
                }
                int length = rawKeys.length;
                for (int j2 = 0; j2 < length; ++j2) {
                    rawKeys[j2] = rawKeys[j2] * (long)cardinality + (long)dictId;
                }
                continue;
            }
            if (rawKeys == null) {
                rawKeys = new long[numValues];
                for (j = 0; j < numValues; ++j) {
                    int dictId = multiValueDictIds[j];
                    rawKeys[j] = rawKey * (long)cardinality + (long)dictId;
                }
                continue;
            }
            int currentLength = rawKeys.length;
            int newLength = currentLength * numValues;
            long[] newRawKeys = new long[newLength];
            for (int j3 = 0; j3 < numValues; ++j3) {
                int startOffset = j3 * currentLength;
                System.arraycopy(rawKeys, 0, newRawKeys, startOffset, currentLength);
                int dictId = multiValueDictIds[j3];
                int endOffset = startOffset + currentLength;
                for (int k = startOffset; k < endOffset; ++k) {
                    newRawKeys[k] = newRawKeys[k] * (long)cardinality + (long)dictId;
                }
            }
            rawKeys = newRawKeys;
        }
        if (rawKeys == null) {
            return new long[]{rawKey};
        }
        return rawKeys;
    }

    private String getGroupKey(long rawKey) {
        int cardinality = this._cardinalities[0];
        StringBuilder groupKeyBuilder = new StringBuilder(this._dictionaries[0].getStringValue((int)(rawKey % (long)cardinality)));
        rawKey /= (long)cardinality;
        for (int i = 1; i < this._numGroupByExpressions; ++i) {
            groupKeyBuilder.append('\u0000');
            cardinality = this._cardinalities[i];
            groupKeyBuilder.append(this._dictionaries[i].getStringValue((int)(rawKey % (long)cardinality)));
            rawKey /= (long)cardinality;
        }
        return groupKeyBuilder.toString();
    }

    private IntArray[] getIntArrayRawKeys(int index) {
        IntArray[] rawKeys = null;
        int[] dictIds = new int[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            int j;
            if (this._isSingleValueColumn[i]) {
                int dictId = this._singleValueDictIds[i][index];
                if (rawKeys == null) {
                    dictIds[i] = dictId;
                    continue;
                }
                for (IntArray rawKey : rawKeys) {
                    rawKey._elements[i] = dictId;
                }
                continue;
            }
            int[] multiValueDictIds = this._multiValueDictIds[i][index];
            int numValues = multiValueDictIds.length;
            if (numValues == 1) {
                int dictId = multiValueDictIds[0];
                if (rawKeys == null) {
                    dictIds[i] = dictId;
                    continue;
                }
                for (IntArray rawKey : rawKeys) {
                    rawKey._elements[i] = dictId;
                }
                continue;
            }
            if (rawKeys == null) {
                rawKeys = new IntArray[numValues];
                for (int j2 = 0; j2 < numValues; ++j2) {
                    int dictId = multiValueDictIds[j2];
                    rawKeys[j2] = new IntArray((int[])dictIds.clone());
                    rawKeys[j2]._elements[i] = dictId;
                }
                continue;
            }
            int currentLength = rawKeys.length;
            int newLength = currentLength * numValues;
            IntArray[] newRawKeys = new IntArray[newLength];
            System.arraycopy(rawKeys, 0, newRawKeys, 0, currentLength);
            for (j = 1; j < numValues; ++j) {
                int offset = j * currentLength;
                for (int k = 0; k < currentLength; ++k) {
                    newRawKeys[offset + k] = new IntArray((int[])rawKeys[k]._elements.clone());
                }
            }
            for (j = 0; j < numValues; ++j) {
                int startOffset = j * currentLength;
                int dictId = multiValueDictIds[j];
                int endOffset = startOffset + currentLength;
                for (int k = startOffset; k < endOffset; ++k) {
                    newRawKeys[k]._elements[i] = dictId;
                }
            }
            rawKeys = newRawKeys;
        }
        if (rawKeys == null) {
            return new IntArray[]{new IntArray(dictIds)};
        }
        return rawKeys;
    }

    private String getGroupKey(IntArray rawKey) {
        StringBuilder groupKeyBuilder = new StringBuilder(this._dictionaries[0].getStringValue(rawKey._elements[0]));
        for (int i = 1; i < this._numGroupByExpressions; ++i) {
            groupKeyBuilder.append('\u0000');
            groupKeyBuilder.append(this._dictionaries[i].getStringValue(rawKey._elements[i]));
        }
        return groupKeyBuilder.toString();
    }

    private static class IntArray {
        public int[] _elements;

        public IntArray(int[] elements) {
            this._elements = elements;
        }

        public int hashCode() {
            int result = 1;
            for (int element : this._elements) {
                result = 31 * result + element;
            }
            return result;
        }

        public boolean equals(Object obj) {
            int length = this._elements.length;
            int[] that = ((IntArray)obj)._elements;
            if (length != that.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this._elements[i] == that[i]) continue;
                return false;
            }
            return true;
        }
    }

    private class ArrayMapBasedHolder
    implements RawKeyHolder {
        private final Object2IntOpenHashMap<IntArray> _rawKeyToGroupIdMap;
        private int _numGroups = 0;

        public ArrayMapBasedHolder(int initialSize) {
            this._rawKeyToGroupIdMap = new Object2IntOpenHashMap(initialSize);
            this._rawKeyToGroupIdMap.defaultReturnValue(-1);
        }

        public ArrayMapBasedHolder(Object rawKeyToGroupIdMap) {
            this._rawKeyToGroupIdMap = (Object2IntOpenHashMap)rawKeyToGroupIdMap;
            this._rawKeyToGroupIdMap.clear();
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int[] dictIds = new int[DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions];
                for (int j = 0; j < DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions; ++j) {
                    dictIds[j] = DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = this.getGroupId(new IntArray(dictIds));
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                IntArray[] rawKeys = DictionaryBasedGroupKeyGenerator.this.getIntArrayRawKeys(i);
                int length = rawKeys.length;
                int[] groupIds = new int[length];
                for (int j = 0; j < length; ++j) {
                    groupIds[j] = this.getGroupId(rawKeys[j]);
                }
                outGroupIds[i] = groupIds;
            }
        }

        private int getGroupId(IntArray rawKey) {
            int groupId = this._rawKeyToGroupIdMap.getInt((Object)rawKey);
            if (groupId == -1 && this._numGroups < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) {
                groupId = this._numGroups;
                this._rawKeyToGroupIdMap.put((Object)rawKey, this._numGroups++);
            }
            return groupId;
        }

        @Override
        public int getGroupIdUpperBound() {
            return this._numGroups;
        }

        @Override
        public Object getInternal() {
            return this._rawKeyToGroupIdMap;
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> iterator() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private final ObjectIterator<Object2IntMap.Entry<IntArray>> _iterator;
                private final GroupKeyGenerator.GroupKey _groupKey;
                {
                    this._iterator = ArrayMapBasedHolder.this._rawKeyToGroupIdMap.object2IntEntrySet().fastIterator();
                    this._groupKey = new GroupKeyGenerator.GroupKey();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
                    this._groupKey._groupId = entry.getIntValue();
                    this._groupKey._stringKey = DictionaryBasedGroupKeyGenerator.this.getGroupKey((IntArray)entry.getKey());
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class LongMapBasedHolder
    implements RawKeyHolder {
        private final Long2IntOpenHashMap _rawKeyToGroupIdMap;
        private int _numGroups = 0;

        public LongMapBasedHolder(int initialSize) {
            this._rawKeyToGroupIdMap = new Long2IntOpenHashMap(initialSize);
            this._rawKeyToGroupIdMap.defaultReturnValue(-1);
        }

        public LongMapBasedHolder(Object rawKeyToGroupIdMap) {
            this._rawKeyToGroupIdMap = (Long2IntOpenHashMap)rawKeyToGroupIdMap;
            this._rawKeyToGroupIdMap.clear();
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                long rawKey = 0L;
                for (int j = DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions - 1; j >= 0; --j) {
                    rawKey = rawKey * (long)DictionaryBasedGroupKeyGenerator.this._cardinalities[j] + (long)DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = this.getGroupId(rawKey);
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                long[] rawKeys = DictionaryBasedGroupKeyGenerator.this.getLongRawKeys(i);
                int length = rawKeys.length;
                int[] groupIds = new int[length];
                for (int j = 0; j < length; ++j) {
                    groupIds[j] = this.getGroupId(rawKeys[j]);
                }
                outGroupIds[i] = groupIds;
            }
        }

        private int getGroupId(long rawKey) {
            int groupId = this._rawKeyToGroupIdMap.get(rawKey);
            if (groupId == -1 && this._numGroups < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) {
                groupId = this._numGroups;
                this._rawKeyToGroupIdMap.put(rawKey, this._numGroups++);
            }
            return groupId;
        }

        @Override
        public int getGroupIdUpperBound() {
            return this._numGroups;
        }

        @Override
        public Object getInternal() {
            return this._rawKeyToGroupIdMap;
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> iterator() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private final ObjectIterator<Long2IntMap.Entry> _iterator;
                private final GroupKeyGenerator.GroupKey _groupKey;
                {
                    this._iterator = LongMapBasedHolder.this._rawKeyToGroupIdMap.long2IntEntrySet().fastIterator();
                    this._groupKey = new GroupKeyGenerator.GroupKey();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    Long2IntMap.Entry entry = (Long2IntMap.Entry)this._iterator.next();
                    this._groupKey._groupId = entry.getIntValue();
                    this._groupKey._stringKey = DictionaryBasedGroupKeyGenerator.this.getGroupKey(entry.getLongKey());
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class IntMapBasedHolder
    implements RawKeyHolder {
        private final Int2IntOpenHashMap _rawKeyToGroupIdMap;
        private int _numGroups = 0;

        public IntMapBasedHolder(int initialSize) {
            this._rawKeyToGroupIdMap = new Int2IntOpenHashMap(initialSize);
            this._rawKeyToGroupIdMap.defaultReturnValue(-1);
        }

        public IntMapBasedHolder(Object hashMap) {
            this._rawKeyToGroupIdMap = (Int2IntOpenHashMap)hashMap;
            this._rawKeyToGroupIdMap.clear();
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int rawKey = 0;
                for (int j = DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions - 1; j >= 0; --j) {
                    rawKey = rawKey * DictionaryBasedGroupKeyGenerator.this._cardinalities[j] + DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = this.getGroupId(rawKey);
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int[] groupIds = DictionaryBasedGroupKeyGenerator.this.getIntRawKeys(i);
                int length = groupIds.length;
                for (int j = 0; j < length; ++j) {
                    groupIds[j] = this.getGroupId(groupIds[j]);
                }
                outGroupIds[i] = groupIds;
            }
        }

        private int getGroupId(int rawKey) {
            int groupId = this._rawKeyToGroupIdMap.get(rawKey);
            if (groupId == -1 && this._numGroups < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound) {
                groupId = this._numGroups;
                this._rawKeyToGroupIdMap.put(rawKey, this._numGroups++);
            }
            return groupId;
        }

        @Override
        public int getGroupIdUpperBound() {
            return this._numGroups;
        }

        @Override
        public Object getInternal() {
            return this._rawKeyToGroupIdMap;
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> iterator() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private final ObjectIterator<Int2IntMap.Entry> _iterator;
                private final GroupKeyGenerator.GroupKey _groupKey;
                {
                    this._iterator = IntMapBasedHolder.this._rawKeyToGroupIdMap.int2IntEntrySet().fastIterator();
                    this._groupKey = new GroupKeyGenerator.GroupKey();
                }

                @Override
                public boolean hasNext() {
                    return this._iterator.hasNext();
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    Int2IntMap.Entry entry = (Int2IntMap.Entry)this._iterator.next();
                    this._groupKey._groupId = entry.getIntValue();
                    this._groupKey._stringKey = DictionaryBasedGroupKeyGenerator.this.getGroupKey(entry.getIntKey());
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class ArrayBasedHolder
    implements RawKeyHolder {
        private final boolean[] _flags;

        private ArrayBasedHolder() {
            this._flags = new boolean[DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound];
        }

        @Override
        public void processSingleValue(int numDocs, int[] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int groupId = 0;
                for (int j = DictionaryBasedGroupKeyGenerator.this._numGroupByExpressions - 1; j >= 0; --j) {
                    groupId = groupId * DictionaryBasedGroupKeyGenerator.this._cardinalities[j] + DictionaryBasedGroupKeyGenerator.this._singleValueDictIds[j][i];
                }
                outGroupIds[i] = groupId;
                this._flags[groupId] = true;
            }
        }

        @Override
        public void processMultiValue(int numDocs, int[][] outGroupIds) {
            for (int i = 0; i < numDocs; ++i) {
                int[] groupIds;
                for (int groupId : groupIds = DictionaryBasedGroupKeyGenerator.this.getIntRawKeys(i)) {
                    this._flags[groupId] = true;
                }
                outGroupIds[i] = groupIds;
            }
        }

        @Override
        public int getGroupIdUpperBound() {
            return DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound;
        }

        @Override
        public Object getInternal() {
            return this._flags;
        }

        @Override
        public Iterator<GroupKeyGenerator.GroupKey> iterator() {
            return new Iterator<GroupKeyGenerator.GroupKey>(){
                private int _currentGroupId;
                private final GroupKeyGenerator.GroupKey _groupKey = new GroupKeyGenerator.GroupKey();

                @Override
                public boolean hasNext() {
                    while (this._currentGroupId < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound && !ArrayBasedHolder.this._flags[this._currentGroupId]) {
                        ++this._currentGroupId;
                    }
                    return this._currentGroupId < DictionaryBasedGroupKeyGenerator.this._globalGroupIdUpperBound;
                }

                @Override
                public GroupKeyGenerator.GroupKey next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this._groupKey._groupId = this._currentGroupId;
                    this._groupKey._stringKey = DictionaryBasedGroupKeyGenerator.this.getGroupKey(this._currentGroupId);
                    ++this._currentGroupId;
                    return this._groupKey;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static interface RawKeyHolder
    extends Iterable<GroupKeyGenerator.GroupKey> {
        public void processSingleValue(int var1, int[] var2);

        public void processMultiValue(int var1, int[][] var2);

        public int getGroupIdUpperBound();

        public Object getInternal();
    }
}

