/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.DictionaryBasedGroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.GroupByExecutor;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.NoDictionaryMultiColumnGroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.NoDictionarySingleColumnGroupKeyGenerator;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class DefaultGroupByExecutor
implements GroupByExecutor {
    private static final ThreadLocal<int[]> THREAD_LOCAL_SV_GROUP_KEYS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL]);
    private static final ThreadLocal<int[][]> THREAD_LOCAL_MV_GROUP_KEYS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][]);
    private static final ThreadLocal<Map> THREAD_LOCAL_DICTIONARY_BASED_GROUP_KEY_HOLDERS = ThreadLocal.withInitial(() -> new HashMap());
    protected final AggregationFunction[] _aggregationFunctions;
    protected final GroupKeyGenerator _groupKeyGenerator;
    protected final GroupByResultHolder[] _groupByResultHolders;
    protected final boolean _hasMVGroupByExpression;
    protected final int[] _svGroupKeys;
    protected final int[][] _mvGroupKeys;

    public DefaultGroupByExecutor(AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, int maxInitialResultHolderCapacity, int numGroupsLimit, TransformOperator transformOperator) {
        this._aggregationFunctions = aggregationFunctions;
        boolean hasMVGroupByExpression = false;
        boolean hasNoDictionaryGroupByExpression = false;
        for (ExpressionContext groupByExpression : groupByExpressions) {
            TransformResultMetadata transformResultMetadata = transformOperator.getResultMetadata(groupByExpression);
            hasMVGroupByExpression |= !transformResultMetadata.isSingleValue();
            hasNoDictionaryGroupByExpression |= !transformResultMetadata.hasDictionary();
        }
        this._hasMVGroupByExpression = hasMVGroupByExpression;
        this._groupKeyGenerator = hasNoDictionaryGroupByExpression ? (groupByExpressions.length == 1 ? new NoDictionarySingleColumnGroupKeyGenerator(transformOperator, groupByExpressions[0], numGroupsLimit) : new NoDictionaryMultiColumnGroupKeyGenerator(transformOperator, groupByExpressions, numGroupsLimit)) : new DictionaryBasedGroupKeyGenerator(transformOperator, groupByExpressions, numGroupsLimit, maxInitialResultHolderCapacity, THREAD_LOCAL_DICTIONARY_BASED_GROUP_KEY_HOLDERS.get());
        int maxNumResults = this._groupKeyGenerator.getGlobalGroupKeyUpperBound();
        int initialCapacity = Math.min(maxNumResults, maxInitialResultHolderCapacity);
        int numAggregationFunctions = aggregationFunctions.length;
        this._groupByResultHolders = new GroupByResultHolder[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._groupByResultHolders[i] = this._aggregationFunctions[i].createGroupByResultHolder(initialCapacity, maxNumResults);
        }
        if (this._hasMVGroupByExpression) {
            this._svGroupKeys = null;
            this._mvGroupKeys = THREAD_LOCAL_MV_GROUP_KEYS.get();
        } else {
            this._svGroupKeys = THREAD_LOCAL_SV_GROUP_KEYS.get();
            this._mvGroupKeys = null;
        }
    }

    @Override
    public void process(TransformBlock transformBlock) {
        if (this._hasMVGroupByExpression) {
            this._groupKeyGenerator.generateKeysForBlock(transformBlock, this._mvGroupKeys);
        } else {
            this._groupKeyGenerator.generateKeysForBlock(transformBlock, this._svGroupKeys);
        }
        int capacityNeeded = this._groupKeyGenerator.getCurrentGroupKeyUpperBound();
        int length = transformBlock.getNumDocs();
        int numAggregationFunctions = this._aggregationFunctions.length;
        for (int i = 0; i < numAggregationFunctions; ++i) {
            GroupByResultHolder groupByResultHolder = this._groupByResultHolders[i];
            groupByResultHolder.ensureCapacity(capacityNeeded);
            this.aggregate(transformBlock, length, i);
        }
    }

    protected void aggregate(TransformBlock transformBlock, int length, int functionIndex) {
        AggregationFunction aggregationFunction = this._aggregationFunctions[functionIndex];
        Map<ExpressionContext, BlockValSet> blockValSetMap = AggregationFunctionUtils.getBlockValSetMap(aggregationFunction, transformBlock);
        GroupByResultHolder groupByResultHolder = this._groupByResultHolders[functionIndex];
        if (this._hasMVGroupByExpression) {
            aggregationFunction.aggregateGroupByMV(length, this._mvGroupKeys, groupByResultHolder, blockValSetMap);
        } else {
            aggregationFunction.aggregateGroupBySV(length, this._svGroupKeys, groupByResultHolder, blockValSetMap);
        }
    }

    @Override
    public AggregationGroupByResult getResult() {
        return new AggregationGroupByResult(this._groupKeyGenerator, this._aggregationFunctions, this._groupByResultHolders);
    }
}

