/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.customobject;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.request.context.OrderByExpressionContext;
import org.apache.pinot.spi.utils.ByteArray;

public class DistinctTable {
    private static final int MAX_INITIAL_CAPACITY = 10000;
    private final DataSchema _dataSchema;
    private final int _limit;
    private final Set<Record> _uniqueRecords;
    private final PriorityQueue<Record> _sortedRecords;
    private final List<Record> _records;

    public DistinctTable(DataSchema dataSchema, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit) {
        this._dataSchema = dataSchema;
        this._limit = limit;
        int initialCapacity = Math.min(limit, 10000);
        this._uniqueRecords = new ObjectOpenHashSet(initialCapacity);
        if (orderByExpressions != null) {
            String[] columns = dataSchema.getColumnNames();
            int numColumns = columns.length;
            Object2IntOpenHashMap columnIndexMap = new Object2IntOpenHashMap(numColumns);
            for (int i = 0; i < numColumns; ++i) {
                columnIndexMap.put((Object)columns[i], i);
            }
            int numOrderByColumns = orderByExpressions.size();
            int[] orderByColumnIndexes = new int[numOrderByColumns];
            boolean[] orderByAsc = new boolean[numOrderByColumns];
            for (int i = 0; i < numOrderByColumns; ++i) {
                OrderByExpressionContext orderByExpression = orderByExpressions.get(i);
                orderByColumnIndexes[i] = columnIndexMap.getInt((Object)orderByExpression.getExpression().toString());
                orderByAsc[i] = orderByExpression.isAsc();
            }
            this._sortedRecords = new PriorityQueue(initialCapacity, (record1, record2) -> {
                Object[] values1 = record1.getValues();
                Object[] values2 = record2.getValues();
                for (int i = 0; i < numOrderByColumns; ++i) {
                    int result;
                    Comparable valueToCompare1 = (Comparable)values1[orderByColumnIndexes[i]];
                    Comparable valueToCompare2 = (Comparable)values2[orderByColumnIndexes[i]];
                    int n = result = orderByAsc[i] ? valueToCompare2.compareTo(valueToCompare1) : valueToCompare1.compareTo(valueToCompare2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            });
        } else {
            this._sortedRecords = null;
        }
        this._records = null;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public int size() {
        if (this._uniqueRecords != null) {
            return this._uniqueRecords.size();
        }
        return this._records.size();
    }

    public boolean hasOrderBy() {
        return this._sortedRecords != null;
    }

    public boolean addWithoutOrderBy(Record record) {
        if (this._uniqueRecords.add(record)) {
            return this.isSatisfied();
        }
        return false;
    }

    public boolean isSatisfied() {
        return this._uniqueRecords.size() == this._limit;
    }

    public void addWithOrderBy(Record record) {
        if (!this._uniqueRecords.contains(record)) {
            if (this._sortedRecords.size() < this._limit) {
                this._uniqueRecords.add(record);
                this._sortedRecords.offer(record);
            } else {
                Record leastRecord = this._sortedRecords.peek();
                if (this._sortedRecords.comparator().compare(record, leastRecord) > 0) {
                    this._uniqueRecords.remove(leastRecord);
                    this._uniqueRecords.add(record);
                    this._sortedRecords.poll();
                    this._sortedRecords.offer(record);
                }
            }
        }
    }

    public void mergeMainDistinctTable(DistinctTable distinctTable) {
        this.mergeRecords(distinctTable._uniqueRecords);
    }

    private void mergeRecords(Collection<Record> records) {
        if (this.hasOrderBy()) {
            for (Record record : records) {
                this.addWithOrderBy(record);
            }
        } else {
            if (this.isSatisfied()) {
                return;
            }
            for (Record record : records) {
                if (!this.addWithoutOrderBy(record)) continue;
                return;
            }
        }
    }

    public byte[] toBytes() throws IOException {
        DataTableBuilder dataTableBuilder = new DataTableBuilder(this._dataSchema);
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        for (Record record : this._uniqueRecords) {
            dataTableBuilder.startRow();
            Object[] values = record.getValues();
            block9: for (int i = 0; i < numColumns; ++i) {
                switch (columnDataTypes[i]) {
                    case INT: {
                        dataTableBuilder.setColumn(i, (Integer)values[i]);
                        continue block9;
                    }
                    case LONG: {
                        dataTableBuilder.setColumn(i, (Long)values[i]);
                        continue block9;
                    }
                    case FLOAT: {
                        dataTableBuilder.setColumn(i, ((Float)values[i]).floatValue());
                        continue block9;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, (Double)values[i]);
                        continue block9;
                    }
                    case STRING: {
                        dataTableBuilder.setColumn(i, (String)values[i]);
                        continue block9;
                    }
                    case BYTES: {
                        dataTableBuilder.setColumn(i, (ByteArray)values[i]);
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build().toBytes();
    }

    public DistinctTable(ByteBuffer byteBuffer) throws IOException {
        DataTable dataTable = DataTableFactory.getDataTable(byteBuffer);
        this._dataSchema = dataTable.getDataSchema();
        this._limit = Integer.MIN_VALUE;
        this._uniqueRecords = null;
        this._sortedRecords = null;
        int numRecords = dataTable.getNumberOfRows();
        DataSchema.ColumnDataType[] columnDataTypes = this._dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        this._records = new ArrayList<Record>(numRecords);
        for (int i = 0; i < numRecords; ++i) {
            Object[] values = new Object[numColumns];
            block9: for (int j = 0; j < numColumns; ++j) {
                switch (columnDataTypes[j]) {
                    case INT: {
                        values[j] = dataTable.getInt(i, j);
                        continue block9;
                    }
                    case LONG: {
                        values[j] = dataTable.getLong(i, j);
                        continue block9;
                    }
                    case FLOAT: {
                        values[j] = Float.valueOf(dataTable.getFloat(i, j));
                        continue block9;
                    }
                    case DOUBLE: {
                        values[j] = dataTable.getDouble(i, j);
                        continue block9;
                    }
                    case STRING: {
                        values[j] = dataTable.getString(i, j);
                        continue block9;
                    }
                    case BYTES: {
                        values[j] = dataTable.getBytes(i, j);
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            this._records.add(new Record(values));
        }
    }

    public void mergeDeserializedDistinctTable(DistinctTable distinctTable) {
        this.mergeRecords(distinctTable._records);
    }

    public Iterator<Record> getFinalResult() {
        if (this._sortedRecords != null) {
            int numRecords = this._sortedRecords.size();
            LinkedList<Record> sortedRecords = new LinkedList<Record>();
            for (int i = 0; i < numRecords; ++i) {
                sortedRecords.addFirst(this._sortedRecords.poll());
            }
            return sortedRecords.iterator();
        }
        return this._uniqueRecords.iterator();
    }
}

