/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function.customobject;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class AvgPair
implements Comparable<AvgPair> {
    private double _sum;
    private long _count;

    public AvgPair(double sum, long count) {
        this._sum = sum;
        this._count = count;
    }

    public void apply(double sum, long count) {
        this._sum += sum;
        this._count += count;
    }

    public void apply(@Nonnull AvgPair avgPair) {
        this._sum += avgPair._sum;
        this._count += avgPair._count;
    }

    public double getSum() {
        return this._sum;
    }

    public long getCount() {
        return this._count;
    }

    @Nonnull
    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putDouble(this._sum);
        byteBuffer.putLong(this._count);
        return byteBuffer.array();
    }

    @Nonnull
    public static AvgPair fromBytes(byte[] bytes) {
        return AvgPair.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    @Nonnull
    public static AvgPair fromByteBuffer(ByteBuffer byteBuffer) {
        return new AvgPair(byteBuffer.getDouble(), byteBuffer.getLong());
    }

    @Override
    public int compareTo(@Nonnull AvgPair avgPair) {
        if (this._count == 0L) {
            if (avgPair._count == 0L) {
                return 0;
            }
            return -1;
        }
        if (avgPair._count == 0L) {
            return 1;
        }
        double avg1 = this._sum / (double)this._count;
        double avg2 = avgPair._sum / (double)avgPair._count;
        if (avg1 > avg2) {
            return 1;
        }
        if (avg1 < avg2) {
            return -1;
        }
        return 0;
    }
}

