/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.function.AggregationFunctionType;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;

public class SumAggregationFunction
extends BaseSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = 0.0;

    public SumAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.SUM;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new DoubleAggregationResultHolder(0.0);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, 0.0);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        double sum = aggregationResultHolder.getDoubleResult();
        for (int i = 0; i < length; ++i) {
            sum += valueArray[i];
        }
        aggregationResultHolder.setValue(sum);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + valueArray[i]);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                groupByResultHolder.setValueForKey(groupKey, groupByResultHolder.getDoubleResult(groupKey) + value);
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateResult1, Double intermediateResult2) {
        return intermediateResult1 + intermediateResult2;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return true;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }
}

